/*
 * Decompiled with CFR 0.152.
 */
package triad.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Scanner;
import triad.backend.Card;
import triad.backend.Hand;
import triad.backend.HandBuilder;

public class ProcessDump {
    public static void main(String[] stringArray) throws IOException {
        Hand hand;
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        HashSet<Hand> hashSet = new HashSet<Hand>();
        HashSet<Card> hashSet2 = new HashSet<Card>();
        boolean[] blArray = new boolean[10];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = false;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while ((hand = ProcessDump.readHand(bufferedReader)) != null) {
            boolean bl = false;
            for (int i = 0; i < 5; ++i) {
                Card card = hand.getCard(i);
                int n3 = card.getLevel();
                hashSet2.add(card);
                blArray[n3 - 1] = true;
                if (n3 != 10) continue;
                bl = true;
            }
            ++n;
            hashSet.add(hand);
            d += (double)hand.edgeSum();
            if (!bl) continue;
            ++n2;
        }
        d /= (double)(n * 5 * 4);
        System.out.println("Total hands processed:         " + n);
        System.out.println("Unique unordered hands played: " + hashSet.size());
        System.out.println("Unique cards played:           " + hashSet2.size());
        System.out.format("Hands with top-level card:     " + n2 + " (%.2f%%)%n", (double)n2 / (double)n * 100.0);
        System.out.format("Average card strength:         %.2f%n", d);
        System.out.println("Levels of cards played:        " + ProcessDump.levelsPlayed(blArray));
    }

    private static Hand readHand(BufferedReader bufferedReader) throws IOException {
        String string;
        do {
            if ((string = bufferedReader.readLine()) != null) continue;
            return null;
        } while ((string = string.trim()).isEmpty());
        Scanner scanner = new Scanner(string);
        HandBuilder handBuilder = new HandBuilder();
        for (int i = 0; i < 5; ++i) {
            handBuilder.add(Card.get(scanner.nextInt()));
        }
        if (scanner.hasNext()) {
            throw new IllegalArgumentException("Invalid hand line: " + string);
        }
        return handBuilder.toHand();
    }

    private static String levelsPlayed(boolean[] blArray) {
        String string = "";
        boolean bl = false;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            if (bl) {
                string = string + ", " + (i + 1);
                continue;
            }
            string = string + (i + 1);
            bl = true;
        }
        return string;
    }
}

