/*
 * Decompiled with CFR 0.152.
 */
package triad.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;
import triad.backend.Board;
import triad.backend.BoardFactory;
import triad.backend.Card;
import triad.backend.Hand;
import triad.backend.HandBuilder;
import triad.backend.IOMethod;
import triad.backend.Move;
import triad.backend.Player;
import triad.backend.SearchVerifier;
import triad.console.ColumnDisplay;

public class IOConsole
implements IOMethod {
    private BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
    private boolean verbose;
    private boolean concedeInput;

    public IOConsole(boolean bl) {
        this.verbose = bl;
    }

    @Override
    public Hand gameStart(Hand hand, BoardFactory boardFactory) {
        HandBuilder handBuilder = new HandBuilder(hand);
        this.printHandRules(handBuilder, boardFactory);
        while (true) {
            System.out.print("(N)ew game | (C)orrect # | (Q)uit: ");
            System.out.flush();
            StringTokenizer stringTokenizer = new StringTokenizer(this.readLine());
            if (!stringTokenizer.hasMoreTokens()) continue;
            char c = stringTokenizer.nextToken().toLowerCase().charAt(0);
            if (c == 'n') {
                System.out.println();
                return handBuilder.toHand();
            }
            if (c == 'q') {
                return null;
            }
            if (c != 'c' || !stringTokenizer.hasMoreTokens()) continue;
            int n = -1;
            try {
                n = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                continue;
            }
            if (n <= 0 || n > 5) continue;
            handBuilder.replace(n - 1, this.readCard(false));
            System.out.println();
            this.printHandRules(handBuilder, boardFactory);
        }
    }

    @Override
    public Hand getOpponentHand(Player player) {
        System.out.println("Input a hand for " + player);
        HandBuilder handBuilder = new HandBuilder();
        for (int i = 0; i < 5; ++i) {
            handBuilder.add(this.readCard(false));
        }
        System.out.println();
        return handBuilder.toHand();
    }

    @Override
    public boolean isPlayerOneFirst(Player player, Player player2) {
        boolean bl = this.readYesNo("Is " + player + " going first? ");
        System.out.println();
        return bl;
    }

    @Override
    public void turnBegins(Player player) {
        System.out.println("Time for " + player + " to move");
    }

    @Override
    public void finalScore(Player player, Player player2, int n, int n2) {
        System.out.println("Final score:  " + n + " - " + n2);
        if (n <= n2) {
            System.out.println();
        }
    }

    @Override
    public void aiStartSearch(int n) {
        System.out.print("Doing depth " + n + " search...");
        System.out.flush();
    }

    @Override
    public void aiEndSearch(Move move, int n, int n2, int n3, long l) {
        Card card = move.getCard();
        int n4 = move.getPosition();
        if (this.verbose) {
            System.out.println(Long.toString(l) + " ms");
            System.out.println("Evaluation = " + n3 + " (" + n + " - " + n2 + ")");
            System.out.println("Play card " + card + " to spot " + n4);
            System.out.println();
        } else {
            System.out.println("\nPlay " + card + " to spot " + n4 + " (score " + n + " - " + n2 + ")\n");
        }
    }

    @Override
    public Move inputManualMove(Board board) {
        Card card;
        if (this.verbose) {
            System.out.println("Available cards:");
            for (int i = 0; i < 5; ++i) {
                Card card2 = board.cardFromSide(i);
                if (card2 == null) continue;
                System.out.println("- " + card2);
            }
        }
        while (true) {
            if ((card = this.readCard(true)) == null) {
                System.out.println();
                return new Move(this.concedeInput);
            }
            boolean bl = false;
            for (int i = 0; i < 5; ++i) {
                Card card3 = board.cardFromSide(i);
                if (card3 == null || !card3.equals(card)) continue;
                bl = true;
                break;
            }
            if (bl) break;
            System.out.println("Card does not match any card in hand");
        }
        Move move = new Move(card, this.inputManualMovePosition(board));
        System.out.println();
        return move;
    }

    @Override
    public Move inputManualMove(Board board, SearchVerifier searchVerifier) {
        Move move;
        boolean bl;
        do {
            if (searchVerifier.verify(move = this.inputManualMove(board))) {
                return move;
            }
            bl = this.readYesNo("WARNING: Move does not match model. Proceed? ");
            System.out.println();
        } while (!bl);
        return move;
    }

    @Override
    public void informBest(Card card) {
        if (card != null) {
            System.out.println("Card to take: " + card + "\n");
        } else {
            System.out.println("Card to take: anything\n");
        }
    }

    private void printHandRules(HandBuilder handBuilder, BoardFactory boardFactory) {
        ColumnDisplay columnDisplay = new ColumnDisplay(2);
        for (int i = 0; i < 5; ++i) {
            columnDisplay.add(0, handBuilder.getCard(i).toString());
        }
        List<String> list = boardFactory.getRules();
        for (String string : list) {
            columnDisplay.add(1, string);
        }
        columnDisplay.display();
    }

    private int inputManualMovePosition(Board board) {
        if (this.verbose) {
            System.out.println("Available locations:");
            String string = "";
            for (int i = 0; i < 9; ++i) {
                if (i % 3 != 0) {
                    string = string + " ";
                }
                string = board.isSquareEmpty(i) ? string + (i + 1) : string + "-";
                if (i % 3 != 2 || i == 8) continue;
                string = string + "\n";
            }
            System.out.println(string);
        }
        int n = -1;
        while (n == -1) {
            n = this.readInteger("Choose a location: ");
            if (n <= 0 || n > 9) {
                System.out.println("Invalid location");
                n = -1;
                continue;
            }
            if (board.isSquareEmpty(n - 1)) continue;
            System.out.println("Position already occupied");
            n = -1;
        }
        return n;
    }

    private Card readCard(boolean bl) {
        int[] nArray = new int[4];
        String string = !bl ? "Enter card: " : "(A)bort | (C)oncede | Enter card: ";
        while (true) {
            System.out.print(string);
            System.out.flush();
            String string2 = this.readLine().trim();
            if (string2.isEmpty()) continue;
            char c = string2.toLowerCase().charAt(0);
            if (bl && c == 'a') {
                this.concedeInput = false;
                return null;
            }
            if (bl && c == 'c') {
                this.concedeInput = true;
                return null;
            }
            Scanner scanner = new Scanner(string2);
            try {
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = scanner.nextInt();
                }
            }
            catch (Exception exception) {
                System.out.println("Invalid integers");
                continue;
            }
            if (scanner.hasNext()) {
                System.out.println("Too many numbers input");
                continue;
            }
            try {
                return Card.get(nArray[0], nArray[1], nArray[2], nArray[3]);
            }
            catch (Exception exception) {
                System.out.println("Card does not exist in Final Fantasy 8");
                continue;
            }
            break;
        }
    }

    private int readInteger(String string) {
        int n = 0;
        while (true) {
            System.out.print(string);
            System.out.flush();
            try {
                String string2 = this.readLine();
                string2 = string2.trim();
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                System.out.println("Invalid integer");
                continue;
            }
            break;
        }
        return n;
    }

    private boolean readYesNo(String string) {
        boolean bl = false;
        while (true) {
            System.out.print(string);
            System.out.flush();
            try {
                String string2 = this.readLine();
                string2 = string2.trim();
                char c = string2.charAt(0);
                if (c == 'Y' || c == 'y') {
                    bl = true;
                    break;
                }
                if (c != 'N' && c != 'n') continue;
                bl = false;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
        return bl;
    }

    private String readLine() {
        String string = null;
        while (string == null) {
            try {
                string = this.in.readLine();
            }
            catch (IOException iOException) {
                System.out.println("Error reading line from standard input");
            }
        }
        return string;
    }
}

