/*
 * Decompiled with CFR 0.152.
 */
package triad.console;

import java.util.ArrayList;
import java.util.List;

public class ColumnDisplay {
    public static final int DEFAULT_SPACE = 8;
    private List<List<String>> columns;
    private int spaces;

    public ColumnDisplay(int n) {
        this(n, 8);
    }

    public ColumnDisplay(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid number of columns");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid number of spaces");
        }
        this.columns = new ArrayList<List<String>>();
        for (int i = 0; i < n; ++i) {
            this.columns.add(new ArrayList());
        }
        this.spaces = n2;
    }

    public void add(int n, String string) {
        if (string == null) {
            throw new IllegalArgumentException("Invalid output string");
        }
        this.columns.get(n).add(string);
    }

    public boolean isColumnEmpty(int n) {
        return this.columns.get(n).isEmpty();
    }

    public void display() {
        int n;
        int n2 = this.columns.size();
        int n3 = 0;
        for (List<String> list : this.columns) {
            if (list.size() <= n3) continue;
            n3 = list.size();
        }
        Object object = new int[n2];
        for (int i = 0; i < n2; ++i) {
            object[i] = (n3 - this.columns.get(i).size()) / 2;
        }
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = 0;
            List<String> list = this.columns.get(n);
            for (String string : list) {
                int n4 = string.length();
                if (n4 <= nArray[n]) continue;
                nArray[n] = n4;
            }
        }
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < n2; ++i) {
                String string;
                List<String> list = this.columns.get(i);
                string = "";
                if (n >= object[i] && n < object[i] + list.size()) {
                    string = (String)list.get(n - object[i]);
                }
                StringBuilder stringBuilder = new StringBuilder(nArray[i] + this.spaces);
                stringBuilder.append(string);
                int n5 = 0;
                if (i != n2 - 1) {
                    n5 = nArray[i] - string.length() + this.spaces;
                }
                for (int j = 0; j < n5; ++j) {
                    stringBuilder.append(' ');
                }
                System.out.print(stringBuilder.toString());
            }
            System.out.println();
        }
    }
}

