/*
 * Decompiled with CFR 0.152.
 */
package triad.backend;

import triad.backend.Board;
import triad.backend.BoardFactory;
import triad.backend.Game;
import triad.backend.Hand;
import triad.backend.IOMethod;
import triad.backend.PlayerAI;
import triad.backend.PlayerManual;
import triad.backend.Preferences;
import triad.backend.PreferencesException;
import triad.backend.SearchAll;
import triad.backend.SearchFF8;
import triad.backend.SearchModel;
import triad.backend.SpoilsMaxEdges;

public class TriadHelper {
    private static final String PREFERENCES = "triadHelper.conf";
    private static final String MODEL_SEARCH = "model.search";
    private static final String MODEL_VERIFY = "model.verify";
    private static final String MODEL_FF8_DEPTH = "model.ff8.depth";
    private static final String VALUE_FULL = "Full";
    private static final String VALUE_FF8 = "FF8";
    private Preferences preferences;
    private SearchModel model;
    private boolean verify;

    public TriadHelper() {
        try {
            this.preferences = new Preferences(PREFERENCES);
        }
        catch (PreferencesException preferencesException) {
            System.err.println(preferencesException);
            System.exit(-1);
        }
        String string = this.preferences.getString(MODEL_SEARCH);
        if (string == null) {
            System.out.println("No opponent model specified, using default");
            string = VALUE_FULL;
        }
        if (string.equalsIgnoreCase(VALUE_FF8)) {
            int n = this.preferences.getInteger(MODEL_FF8_DEPTH);
            System.out.println("Opponent model: FF8's alpha-beta, depth " + n);
            this.model = new SearchFF8(n);
        } else if (!string.equalsIgnoreCase(VALUE_FULL)) {
            System.out.println("Unrecognized opponent model, using default");
            string = VALUE_FULL;
        }
        if (string.equalsIgnoreCase(VALUE_FULL)) {
            System.out.println("Opponent model: full search");
            this.model = new SearchAll();
        }
        this.verify = this.preferences.getBoolean(MODEL_VERIFY);
        System.out.println("Model verification: " + (this.verify ? "on" : "off") + "\n");
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public void run(IOMethod iOMethod) {
        PlayerAI playerAI = new PlayerAI("Human Player", this.model, iOMethod);
        PlayerManual playerManual = new PlayerManual("Final Fantasy", iOMethod);
        if (this.verify) {
            playerManual.setVerification(this.model);
        }
        Game game = new Game(playerAI, playerManual, iOMethod);
        BoardFactory boardFactory = new BoardFactory();
        Hand hand = this.preferences.getStartingHand();
        SpoilsMaxEdges spoilsMaxEdges = new SpoilsMaxEdges(iOMethod);
        while ((hand = iOMethod.gameStart(hand, boardFactory)) != null) {
            Hand hand2 = iOMethod.getOpponentHand(playerManual);
            Board board = boardFactory.createBoard(hand, hand2);
            if (!game.play(board)) continue;
            hand = spoilsMaxEdges.takeCard(hand, hand2);
        }
    }
}

