/*
 * Decompiled with CFR 0.152.
 */
package triad.backend;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import triad.backend.Board;
import triad.backend.Card;
import triad.backend.Move;
import triad.backend.SearchBranch;
import triad.backend.SearchModel;

public class SearchVerifier {
    private List<SearchBranch> moves;
    private Board board;

    public SearchVerifier(SearchModel searchModel, Board board) {
        this.board = board;
        this.moves = new ArrayList<SearchBranch>();
        Iterator<SearchBranch> iterator = searchModel.model(board);
        while (iterator.hasNext()) {
            this.moves.add(iterator.next());
        }
    }

    public boolean verify(Move move) {
        if (move.isAbort() || move.isConcede()) {
            return true;
        }
        int n = move.getPosition() - 1;
        int n2 = -1;
        Card card = move.getCard();
        for (int i = 0; i < 5; ++i) {
            Card object = this.board.cardFromSide(i);
            if (object == null || !object.equals(card)) continue;
            n2 = i;
            break;
        }
        for (SearchBranch searchBranch : this.moves) {
            if (searchBranch.getCard() != n2 || searchBranch.getSpace() != n) continue;
            return true;
        }
        return false;
    }
}

