/*
 * Decompiled with CFR 0.152.
 */
package triad.backend;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import triad.backend.Board;
import triad.backend.SearchBranch;
import triad.backend.SearchModel;

public class SearchFF8
implements SearchModel {
    private static final int MIN_BOUND = -10;
    private static final int MAX_BOUND = 10;
    private int maxSearchDepth;
    private List<SearchBranch> bestMoves;
    private int recordDepth;

    public SearchFF8(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Illegal search depth");
        }
        this.maxSearchDepth = n;
    }

    @Override
    public Iterator<SearchBranch> model(Board board) {
        this.bestMoves = new ArrayList<SearchBranch>();
        this.recordDepth = board.numFreeLocations();
        if (this.recordDepth > this.maxSearchDepth) {
            this.recordDepth = this.maxSearchDepth;
        }
        int n = this.alphaBeta(this.recordDepth, -10, 10, board);
        return this.bestMoves.listIterator();
    }

    private int alphaBeta(int n, int n2, int n3, Board board) {
        if (n == 0) {
            return board.score();
        }
        for (int i = 4; i >= 0; --i) {
            if (!board.isCardOnSide(i)) continue;
            for (int j = 0; j < 9; ++j) {
                if (!board.isSquareEmpty(j)) continue;
                board.play(i, j);
                board.invert();
                int n4 = -this.alphaBeta(n - 1, -n3, -n2, board);
                board.invert();
                board.undo();
                if (n4 > n3) {
                    return n4;
                }
                if (n4 > n2) {
                    n2 = n4;
                    if (n != this.recordDepth) continue;
                    this.bestMoves.clear();
                    this.bestMoves.add(new SearchBranch(i, j));
                    continue;
                }
                if (n4 != n2 || n != this.recordDepth) continue;
                this.bestMoves.add(new SearchBranch(i, j));
            }
        }
        return n2;
    }
}

