/*
 * Decompiled with CFR 0.152.
 */
package triad.backend;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import triad.backend.Card;
import triad.backend.Hand;
import triad.backend.HandBuilder;
import triad.backend.PreferencesException;

public class Preferences {
    private static final char COMMENT = '#';
    private static final char SETTING = '=';
    private Hand startingHand;
    private Map<String, String> settings = new HashMap<String, String>();
    private List<String> cmdLineFlags = new ArrayList<String>();
    private List<String> cmdLineSettings = new ArrayList<String>();
    private List<Boolean> cmdLineValues = new ArrayList<Boolean>();

    public Preferences(String string) throws PreferencesException {
        try {
            this.parseFile(string);
        }
        catch (IOException iOException) {
            throw new PreferencesException("Error reading file: " + string);
        }
    }

    public void addFlag(String string, String string2) {
        this.addFlag(string, string2, true);
    }

    public void addFlag(String string, String string2, boolean bl) {
        String string3 = string.toLowerCase().trim();
        if (this.cmdLineFlags.contains(string3)) {
            throw new IllegalArgumentException("Flag already added: " + string);
        }
        this.cmdLineFlags.add(string3);
        this.cmdLineSettings.add(string2.toLowerCase().trim());
        this.cmdLineValues.add(bl);
    }

    public void parseCommandLine(String[] stringArray) throws PreferencesException {
        for (int i = 0; i < stringArray.length; ++i) {
            int n = this.cmdLineFlags.indexOf(stringArray[i].toLowerCase().trim());
            if (n < 0) {
                String string = "Options:";
                for (String string2 : this.cmdLineFlags) {
                    string = string + "\n    " + string2;
                }
                throw new PreferencesException(string);
            }
            boolean bl = this.cmdLineValues.get(n);
            String string = bl ? "1" : "0";
            this.settings.put(this.cmdLineSettings.get(n), string);
        }
    }

    public Hand getStartingHand() {
        return this.startingHand;
    }

    public String getString(String string) {
        return this.settings.get(string.toLowerCase().trim());
    }

    public boolean getBoolean(String string) {
        int n;
        String string2 = this.settings.get(string.toLowerCase().trim());
        if (string2 == null || string2.isEmpty()) {
            return false;
        }
        try {
            n = Integer.valueOf(string2);
        }
        catch (Exception exception) {
            return true;
        }
        return n != 0;
    }

    public int getInteger(String string) {
        String string2 = this.settings.get(string.toLowerCase().trim());
        if (string2 == null || string2.isEmpty()) {
            return -1;
        }
        try {
            return Integer.valueOf(string2);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private void parseFile(String string) throws IOException, PreferencesException {
        String string2;
        HandBuilder handBuilder = new HandBuilder();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        while ((string2 = bufferedReader.readLine()) != null) {
            int n = string2.indexOf(35);
            if (n >= 0) {
                string2 = string2.substring(0, n);
            }
            if ((string2 = string2.trim()).isEmpty()) continue;
            int n2 = string2.indexOf(61);
            if (n2 < 0) {
                this.parseCardLine(string2, handBuilder);
                continue;
            }
            String string3 = string2.substring(0, n2).toLowerCase().trim();
            String string4 = string2.substring(n2 + 1).trim();
            this.parseSettingLine(string3, string4);
        }
        if (handBuilder.getNumCards() != 5) {
            throw new PreferencesException("Starting hand not specified in preferences file");
        }
        this.startingHand = handBuilder.toHand();
    }

    private void parseSettingLine(String string, String string2) throws PreferencesException {
        if (string.isEmpty()) {
            throw new PreferencesException("Empty setting name in preferences file");
        }
        if (this.settings.containsKey(string)) {
            throw new PreferencesException("Duplicate setting in preferences file: " + string);
        }
        this.settings.put(string, string2);
    }

    private void parseCardLine(String string, HandBuilder handBuilder) throws PreferencesException {
        Card card;
        int[] nArray = new int[4];
        Scanner scanner = new Scanner(string);
        boolean bl = false;
        try {
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = scanner.nextInt();
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl || scanner.hasNext()) {
            throw new PreferencesException("Invalid card line: " + string);
        }
        try {
            card = Card.get(nArray[0], nArray[1], nArray[2], nArray[3]);
        }
        catch (Exception exception) {
            throw new PreferencesException("Card does not exist: " + string);
        }
        if (handBuilder.getNumCards() == 5) {
            throw new PreferencesException("Too many cards in preferences file");
        }
        handBuilder.add(card);
    }
}

