/*
 * Decompiled with CFR 0.152.
 */
package triad.backend;

import java.util.Iterator;
import triad.backend.Board;
import triad.backend.Card;
import triad.backend.IOMethod;
import triad.backend.Move;
import triad.backend.Player;
import triad.backend.SearchAll;
import triad.backend.SearchBranch;
import triad.backend.SearchModel;

public class PlayerAI
extends Player {
    private static final int MIN_BOUND = -2147483638;
    private static final int MAX_BOUND = 0x7FFFFFF5;
    private static final int CARD_SCORE = 100;
    private int recordDepth;
    private SearchBranch bestMove;
    private SearchModel myModel = new SearchAll();
    private SearchModel oppModel;

    public PlayerAI(String string, IOMethod iOMethod) {
        super(string, iOMethod);
        this.oppModel = new SearchAll();
    }

    public PlayerAI(String string, SearchModel searchModel, IOMethod iOMethod) {
        super(string, iOMethod);
        this.oppModel = searchModel;
    }

    @Override
    public Move getMove(Board board) {
        long l = System.currentTimeMillis();
        this.recordDepth = board.numFreeLocations();
        this.io.aiStartSearch(this.recordDepth);
        this.bestMove = null;
        int n = this.alphaBeta(this.recordDepth, -2147483638, 0x7FFFFFF5, board, this.myModel, this.oppModel);
        int n2 = (int)Math.round((double)n / 100.0);
        if (n2 < 0) {
            n2 = 10 + n2;
        }
        int n3 = 10 - n2;
        long l2 = System.currentTimeMillis() - l;
        Card card = board.cardFromSide(this.bestMove.getCard());
        Move move = new Move(card, this.bestMove.getSpace() + 1);
        this.io.aiEndSearch(move, n2, n3, n, l2);
        return move;
    }

    private int alphaBeta(int n, int n2, int n3, Board board, SearchModel searchModel, SearchModel searchModel2) {
        if (n == 0) {
            return this.evaluate(board);
        }
        Iterator<SearchBranch> iterator = searchModel.model(board);
        while (iterator.hasNext()) {
            SearchBranch searchBranch = iterator.next();
            board.play(searchBranch.getCard(), searchBranch.getSpace());
            board.invert();
            int n4 = -this.alphaBeta(n - 1, -n3, -n2, board, searchModel2, searchModel);
            board.invert();
            board.undo();
            if (n4 >= n3) {
                return n4;
            }
            if (n4 <= n2) continue;
            n2 = n4;
            if (n != this.recordDepth) continue;
            this.bestMove = searchBranch;
        }
        return n2;
    }

    private int evaluate(Board board) {
        int n = board.score() * 100;
        for (int i = 0; i < 5; ++i) {
            Card card = board.cardFromSide(i);
            if (card == null) continue;
            n += card.getEdgeSum();
            break;
        }
        return n;
    }
}

