/*
 * Decompiled with CFR 0.152.
 */
package triad.backend;

import triad.backend.Card;

public class Move {
    public static final int MIN_POSITION = 1;
    public static final int MAX_POSITION = 9;
    private Card card;
    private int position;
    private boolean concede;

    public Move(Card card, int n) {
        if (card == null) {
            throw new IllegalArgumentException("Invalid card");
        }
        if (n < 1 || n > 9) {
            throw new IllegalArgumentException("Invalid position: " + n);
        }
        this.card = card;
        this.position = n;
    }

    public Move(boolean bl) {
        this.card = null;
        this.position = -1;
        this.concede = bl;
    }

    public Card getCard() {
        return this.card;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isAbort() {
        return this.card == null && !this.concede;
    }

    public boolean isConcede() {
        return this.card == null && this.concede;
    }
}

