/*
 * Decompiled with CFR 0.152.
 */
package triad.backend;

import triad.backend.Card;
import triad.backend.Hand;

public class HandBuilder {
    private Card[] cards = new Card[5];
    private int numCards;

    public HandBuilder() {
        this.numCards = 0;
    }

    public HandBuilder(Hand hand) {
        this.numCards = 5;
        for (int i = 0; i < this.numCards; ++i) {
            this.cards[i] = hand.getCard(i);
        }
    }

    public Hand toHand() {
        if (this.numCards != 5) {
            throw new IllegalStateException("Invalid number of cards in hand");
        }
        return new Hand(this.cards);
    }

    public int getNumCards() {
        return this.numCards;
    }

    public Card getCard(int n) {
        if (n < 0 || n >= this.numCards) {
            throw new ArrayIndexOutOfBoundsException("Invalid array index");
        }
        return this.cards[n];
    }

    public void add(Card card) {
        if (this.numCards == 5) {
            throw new ArrayIndexOutOfBoundsException("Full hand");
        }
        if (card == null) {
            throw new IllegalArgumentException("Invalid card");
        }
        this.cards[this.numCards++] = card;
    }

    public void replace(int n, Card card) {
        if (n < 0 || n >= this.numCards) {
            throw new ArrayIndexOutOfBoundsException("Invalid card index");
        }
        if (card == null) {
            throw new IllegalArgumentException("Invalid card");
        }
        this.cards[n] = card;
    }

    public boolean offer(Card card) {
        if (card == null) {
            throw new IllegalArgumentException("Invalid card");
        }
        if (this.numCards < 5) {
            this.add(card);
            return true;
        }
        int n = 0;
        for (int i = 1; i < this.numCards; ++i) {
            if (this.cards[i].compareTo(this.cards[n]) >= 0) continue;
            n = i;
        }
        if (this.cards[n].compareTo(card) < 0) {
            this.cards[n] = card;
            return true;
        }
        return false;
    }
}

