/*
 * Decompiled with CFR 0.152.
 */
package triad.backend;

import triad.backend.Card;

public class Hand {
    public static final int SIZE = 5;
    private Card[] cards;

    public Hand(Card[] cardArray) {
        if (cardArray.length != 5) {
            throw new IllegalArgumentException("Invalid number of cards");
        }
        this.cards = new Card[5];
        for (int i = 0; i < 5; ++i) {
            int n = i;
            for (int j = i + 1; j < 5; ++j) {
                if (cardArray[j].compareTo(cardArray[n]) <= 0) continue;
                n = j;
            }
            this.cards[i] = cardArray[n];
            cardArray[n] = cardArray[i];
        }
    }

    public Card getCard(int n) {
        return this.cards[n];
    }

    public int edgeSum() {
        int n = 0;
        for (int i = 0; i < 5; ++i) {
            n += this.cards[i].getEdgeSum();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Hand)) {
            return false;
        }
        Hand hand = (Hand)object;
        for (int i = 0; i < 5; ++i) {
            if (this.cards[i].equals(hand.cards[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < 5; ++i) {
            n <<= 6;
            n ^= this.cards[i].hashCode();
        }
        return n;
    }
}

