/*
 * Decompiled with CFR 0.152.
 */
package triad.backend;

import triad.backend.Board;
import triad.backend.IOMethod;
import triad.backend.Move;
import triad.backend.Player;

public class Game {
    private Player one;
    private Player two;
    private IOMethod io;

    public Game(Player player, Player player2, IOMethod iOMethod) {
        this.one = player;
        this.two = player2;
        this.io = iOMethod;
    }

    public boolean play(Board board) {
        int n;
        boolean bl = this.io.isPlayerOneFirst(this.one, this.two);
        if (!bl) {
            board.invert();
        }
        for (n = 0; n < 9; ++n) {
            Player player = bl ? this.one : this.two;
            this.io.turnBegins(player);
            Move move = player.getMove(board);
            if (move.isAbort()) {
                return false;
            }
            if (move.isConcede()) {
                return !bl;
            }
            board.play(move);
            bl = !bl;
            board.invert();
        }
        if (!bl) {
            board.invert();
        }
        n = board.score();
        int n2 = 10 - n;
        this.io.finalScore(this.one, this.two, n, n2);
        return n > n2;
    }
}

