/*
 * Decompiled with CFR 0.152.
 */
package triad.backend;

import triad.backend.Element;

public class Card
implements Comparable<Card> {
    public static final int NUM_CARDS = 110;
    public static final int CARDS_PER_LEVEL = 11;
    public static final int MIN_LEVEL = 1;
    public static final int MAX_LEVEL = 10;
    public static final int MIN_VALUE = 1;
    public static final int MAX_VALUE = 10;
    private static final Card[] ALL_CARDS = Card.initializeAllCards();
    private String name;
    private int index;
    private int top;
    private int right;
    private int bottom;
    private int left;
    private int sum;
    private Element element;

    private Card(String string, int n, int n2, int n3, int n4, int n5, Element element) {
        if (n2 < 1 || n2 > 10 || n3 < 1 || n3 > 10 || n4 < 1 || n4 > 10 || n5 < 1 || n5 > 10) {
            throw new IllegalArgumentException("Invalid card edge value");
        }
        if (n < 0 || n >= 110) {
            throw new IllegalArgumentException("Invalid card index");
        }
        this.name = string;
        this.index = n;
        this.top = n2;
        this.right = n3;
        this.bottom = n4;
        this.left = n5;
        this.sum = n2 + n3 + n4 + n5;
        this.element = element;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLevel() {
        return this.index / 11 + 1;
    }

    public int getTop() {
        return this.top;
    }

    public int getRight() {
        return this.right;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getLeft() {
        return this.left;
    }

    public int getEdgeSum() {
        return this.sum;
    }

    public int getSmallestEdge() {
        int n = this.top;
        if (this.right < n) {
            n = this.right;
        }
        if (this.bottom < n) {
            n = this.bottom;
        }
        if (this.left < n) {
            n = this.left;
        }
        return n;
    }

    public int getLargestEdge() {
        int n = this.top;
        if (this.right > n) {
            n = this.right;
        }
        if (this.bottom > n) {
            n = this.bottom;
        }
        if (this.left > n) {
            n = this.left;
        }
        return n;
    }

    public Element getElement() {
        return this.element;
    }

    public String toString() {
        return Integer.toString(this.top) + " " + this.right + " " + this.bottom + " " + this.left;
    }

    @Override
    public int compareTo(Card card) {
        return this.index - card.index;
    }

    public static Card get(int n, int n2, int n3, int n4) {
        for (int i = 0; i < ALL_CARDS.length; ++i) {
            Card card = ALL_CARDS[i];
            if (card.top != n || card.right != n2 || card.bottom != n3 || card.left != n4) continue;
            return card;
        }
        throw new IllegalArgumentException("Card does not exist in FF8");
    }

    public static Card get(int n) {
        if (n < 0 || n >= 110) {
            throw new IllegalArgumentException("Invalid card index: " + n);
        }
        return ALL_CARDS[n];
    }

    private static Card[] initializeAllCards() {
        Card[] cardArray = new Card[]{new Card("Geezard", 0, 1, 4, 1, 5, Element.NONE), new Card("Fungar", 1, 5, 1, 1, 3, Element.NONE), new Card("Bite Bug", 2, 1, 3, 3, 5, Element.NONE), new Card("Red Bat", 3, 6, 1, 1, 2, Element.NONE), new Card("Blobra", 4, 2, 3, 1, 5, Element.NONE), new Card("Gayla", 5, 2, 1, 4, 4, Element.THUNDER), new Card("Gesper", 6, 1, 5, 4, 1, Element.NONE), new Card("Fastitocalon-F", 7, 3, 5, 2, 1, Element.EARTH), new Card("Blood Soul", 8, 2, 1, 6, 1, Element.NONE), new Card("Caterchipillar", 9, 4, 2, 4, 3, Element.NONE), new Card("Cockatrice", 10, 2, 1, 2, 6, Element.THUNDER), new Card("Grat", 11, 7, 1, 3, 1, Element.NONE), new Card("Buel", 12, 6, 2, 2, 3, Element.NONE), new Card("Mesmerize", 13, 5, 3, 3, 4, Element.NONE), new Card("Glacial Eye", 14, 6, 1, 4, 3, Element.ICE), new Card("Belhelmel", 15, 3, 4, 5, 3, Element.NONE), new Card("Thrustaevis", 16, 5, 3, 2, 5, Element.WIND), new Card("Anacondaur", 17, 5, 1, 3, 5, Element.POISON), new Card("Creeps", 18, 5, 2, 5, 2, Element.THUNDER), new Card("Grendel", 19, 4, 4, 5, 2, Element.THUNDER), new Card("Jelleye", 20, 3, 2, 1, 7, Element.NONE), new Card("Grand Mantis", 21, 5, 2, 5, 3, Element.NONE), new Card("Forbidden", 22, 6, 6, 3, 2, Element.NONE), new Card("Armadodo", 23, 6, 3, 1, 6, Element.EARTH), new Card("Tri-Face", 24, 3, 5, 5, 5, Element.POISON), new Card("Fastitcalon", 25, 7, 5, 1, 3, Element.EARTH), new Card("Snow Lion", 26, 7, 1, 5, 3, Element.ICE), new Card("Ochu", 27, 5, 6, 3, 3, Element.NONE), new Card("SAM08G", 28, 5, 6, 2, 4, Element.FIRE), new Card("Death Claw", 29, 4, 4, 7, 2, Element.FIRE), new Card("Cactaur", 30, 6, 2, 6, 3, Element.NONE), new Card("Tonberry", 31, 3, 6, 4, 4, Element.NONE), new Card("Abyss Worm", 32, 7, 2, 3, 5, Element.EARTH), new Card("Turtapod", 33, 2, 3, 6, 7, Element.NONE), new Card("Vysage", 34, 6, 5, 4, 5, Element.NONE), new Card("T-Rexaur", 35, 4, 6, 2, 7, Element.NONE), new Card("Bomb", 36, 2, 7, 6, 3, Element.FIRE), new Card("Blitz", 37, 1, 6, 4, 7, Element.THUNDER), new Card("Wendigo", 38, 7, 3, 1, 6, Element.NONE), new Card("Torama", 39, 7, 4, 4, 4, Element.NONE), new Card("Imp", 40, 3, 7, 3, 6, Element.NONE), new Card("Blue Dragon", 41, 6, 2, 7, 3, Element.POISON), new Card("Adamantiose", 42, 4, 5, 5, 6, Element.EARTH), new Card("Hexadragon", 43, 7, 5, 4, 3, Element.FIRE), new Card("Iron Giant", 44, 6, 5, 6, 5, Element.NONE), new Card("Behemoth", 45, 3, 6, 5, 7, Element.NONE), new Card("Chimera", 46, 7, 6, 5, 3, Element.WATER), new Card("PuPu", 47, 3, 10, 2, 1, Element.NONE), new Card("Elastiod", 48, 6, 2, 6, 7, Element.NONE), new Card("GIM47N", 49, 5, 5, 7, 4, Element.NONE), new Card("Malboro", 50, 7, 7, 4, 2, Element.POISON), new Card("Ruby Dragon", 51, 7, 2, 7, 4, Element.FIRE), new Card("Elnoyle", 52, 5, 3, 7, 6, Element.NONE), new Card("Tonberry King", 53, 4, 6, 7, 4, Element.NONE), new Card("Wedge, Biggs", 54, 6, 6, 2, 7, Element.NONE), new Card("Fujin, Raijin", 55, 2, 8, 8, 4, Element.NONE), new Card("Elvoret", 56, 7, 8, 3, 4, Element.WIND), new Card("X-ATM092", 57, 4, 8, 7, 3, Element.NONE), new Card("Granaldo", 58, 7, 2, 8, 5, Element.NONE), new Card("Gerogero", 59, 1, 8, 8, 3, Element.POISON), new Card("Iguion", 60, 8, 2, 8, 2, Element.NONE), new Card("Abadon", 61, 6, 8, 4, 5, Element.NONE), new Card("Trauma", 62, 4, 8, 5, 6, Element.NONE), new Card("Oilboyle", 63, 1, 8, 4, 8, Element.NONE), new Card("Shumi Tribe", 64, 6, 5, 8, 4, Element.NONE), new Card("Krysta", 65, 7, 5, 8, 1, Element.NONE), new Card("Propagator", 66, 8, 4, 4, 8, Element.NONE), new Card("Jumbo Cactaur", 67, 8, 8, 4, 4, Element.NONE), new Card("Tri-Point", 68, 8, 5, 2, 8, Element.THUNDER), new Card("Gargantua", 69, 5, 6, 6, 8, Element.NONE), new Card("Mobile Type 8", 70, 8, 6, 7, 3, Element.NONE), new Card("Sphinxara", 71, 8, 3, 5, 8, Element.NONE), new Card("Tiamat", 72, 8, 8, 5, 4, Element.NONE), new Card("BGH251F2", 73, 5, 7, 8, 5, Element.NONE), new Card("Red Giant", 74, 6, 8, 4, 7, Element.NONE), new Card("Catoblepas", 75, 1, 8, 7, 7, Element.NONE), new Card("Ultima Weapon", 76, 7, 7, 2, 8, Element.NONE), new Card("Chubby Chocobo", 77, 4, 4, 8, 9, Element.NONE), new Card("Angelo", 78, 9, 6, 7, 3, Element.NONE), new Card("Gilgamesh", 79, 3, 7, 9, 6, Element.NONE), new Card("MiniMog", 80, 9, 3, 9, 2, Element.NONE), new Card("Chicobo", 81, 9, 4, 8, 4, Element.NONE), new Card("Quezacotl", 82, 2, 9, 9, 4, Element.THUNDER), new Card("Shiva", 83, 6, 7, 4, 9, Element.ICE), new Card("Ifrit", 84, 9, 6, 2, 8, Element.FIRE), new Card("Siren", 85, 8, 9, 6, 2, Element.NONE), new Card("Sacred", 86, 5, 1, 9, 9, Element.EARTH), new Card("Minotaur", 87, 9, 5, 2, 9, Element.EARTH), new Card("Carbuncle", 88, 8, 4, 10, 4, Element.NONE), new Card("Diablos", 89, 5, 10, 8, 3, Element.NONE), new Card("Leviathan", 90, 7, 10, 1, 7, Element.WATER), new Card("Odin", 91, 8, 10, 3, 5, Element.NONE), new Card("Pandemona", 92, 10, 1, 7, 7, Element.WIND), new Card("Cerberus", 93, 7, 4, 6, 10, Element.NONE), new Card("Alexander", 94, 9, 10, 4, 2, Element.HOLY), new Card("Phoenix", 95, 7, 2, 7, 10, Element.FIRE), new Card("Bahumut", 96, 10, 8, 2, 6, Element.NONE), new Card("Doomtrain", 97, 3, 1, 10, 10, Element.POISON), new Card("Eden", 98, 4, 4, 9, 10, Element.NONE), new Card("Ward", 99, 10, 7, 2, 8, Element.NONE), new Card("Kiros", 100, 6, 7, 6, 10, Element.NONE), new Card("Laguna", 101, 5, 10, 3, 9, Element.NONE), new Card("Selphie", 102, 10, 8, 6, 4, Element.NONE), new Card("Quistis", 103, 9, 6, 10, 2, Element.NONE), new Card("Irvine", 104, 2, 6, 9, 10, Element.NONE), new Card("Zell", 105, 8, 5, 10, 6, Element.NONE), new Card("Rinoa", 106, 4, 10, 2, 10, Element.NONE), new Card("Edea", 107, 10, 10, 3, 3, Element.NONE), new Card("Seifer", 108, 6, 9, 10, 4, Element.NONE), new Card("Squall", 109, 10, 4, 6, 9, Element.NONE)};
        return cardArray;
    }
}

