/*
 * Decompiled with CFR 0.152.
 */
package triad.backend;

import triad.backend.Card;
import triad.backend.Hand;
import triad.backend.Move;

public abstract class Board {
    public static final int NUM_SQUARES = 9;
    public static final int NUM_SIDE = 5;
    protected boolean amPlayerOne = true;
    protected Card[] board = new Card[9];
    protected boolean[] ownedByOne = new boolean[9];
    private Card[] sideOne = new Card[5];
    private Card[] sideTwo = new Card[5];
    private int movesMade = 0;
    private int scoreOne = 5;
    private int[] moveLocation;
    private int[] moveCardIndex;
    private int[] moveNumFlipped;
    private int[][] moveCardsFlipped;

    public Board(Hand hand, Hand hand2, int n) {
        int n2;
        for (n2 = 0; n2 < 9; ++n2) {
            this.board[n2] = null;
        }
        for (n2 = 0; n2 < 5; ++n2) {
            this.sideOne[n2] = hand.getCard(n2);
            this.sideTwo[n2] = hand2.getCard(n2);
        }
        this.moveLocation = new int[9];
        this.moveCardIndex = new int[9];
        this.moveNumFlipped = new int[9];
        this.moveCardsFlipped = new int[9][];
        for (n2 = 0; n2 < this.moveCardsFlipped.length; ++n2) {
            this.moveCardsFlipped[n2] = new int[n];
        }
    }

    public void invert() {
        this.amPlayerOne = !this.amPlayerOne;
    }

    public int numFreeLocations() {
        return 9 - this.movesMade;
    }

    public int score() {
        return this.amPlayerOne ? this.scoreOne : 10 - this.scoreOne;
    }

    public Card cardFromSide(int n) {
        return this.amPlayerOne ? this.sideOne[n] : this.sideTwo[n];
    }

    public boolean isSquareEmpty(int n) {
        return this.board[n] == null;
    }

    public boolean isCardOnSide(int n) {
        return this.amPlayerOne ? this.sideOne[n] != null : this.sideTwo[n] != null;
    }

    public void play(Move move) {
        if (move.isAbort() || move.isConcede()) {
            throw new IllegalArgumentException("Unsupported move");
        }
        Card card = move.getCard();
        Card[] cardArray = this.amPlayerOne ? this.sideOne : this.sideTwo;
        for (int i = 0; i < cardArray.length; ++i) {
            if (cardArray[i] == null || !cardArray[i].equals(card)) continue;
            this.play(i, move.getPosition() - 1);
            return;
        }
        throw new IllegalArgumentException("Card not available to play");
    }

    public void play(int n, int n2) {
        Card[] cardArray;
        Card[] cardArray2 = cardArray = this.amPlayerOne ? this.sideOne : this.sideTwo;
        if (cardArray[n] == null) {
            throw new IllegalArgumentException("Card not available for play");
        }
        if (this.board[n2] != null) {
            throw new IllegalArgumentException("Space not available for play");
        }
        this.board[n2] = cardArray[n];
        this.ownedByOne[n2] = this.amPlayerOne;
        cardArray[n] = null;
        int[] nArray = this.moveCardsFlipped[this.movesMade];
        int n3 = this.computeFlips(n2, nArray);
        for (int i = 0; i < n3; ++i) {
            this.ownedByOne[nArray[i]] = this.amPlayerOne;
        }
        this.scoreOne = this.amPlayerOne ? (this.scoreOne += n3) : (this.scoreOne -= n3);
        this.moveLocation[this.movesMade] = n2;
        this.moveCardIndex[this.movesMade] = n;
        this.moveNumFlipped[this.movesMade] = n3;
        ++this.movesMade;
    }

    public void undo() {
        int n;
        int n2;
        if (this.movesMade == 0) {
            throw new IllegalStateException("No cards in play");
        }
        --this.movesMade;
        int n3 = this.moveNumFlipped[this.movesMade];
        for (n2 = 0; n2 < n3; ++n2) {
            n = this.moveCardsFlipped[this.movesMade][n2];
            this.ownedByOne[n] = !this.ownedByOne[n];
        }
        n2 = this.moveLocation[this.movesMade];
        n = this.moveCardIndex[this.movesMade];
        if (this.ownedByOne[n2]) {
            this.sideOne[n] = this.board[n2];
            this.scoreOne -= n3;
        } else {
            this.sideTwo[n] = this.board[n2];
            this.scoreOne += n3;
        }
        this.board[n2] = null;
    }

    protected abstract int computeFlips(int var1, int[] var2);
}

