<?php

  if (!defined("SDA_VALIDENTRY"))
    die();

  // define tags to be used by inc_parser
  $sda_parser_tags = array();

  // tags:
  // [hr] - rule
  // [x ????] - unicode char
  // [b] [/b] - bold
  // [i] [/i] - italics
  // [u] [/u] - underline
  // [ul] ... [li] ... [li] ... [/ul]
  // [ol] ... [li] ... [li] ... [/ol] - lists
  // [-] - mdash
  // [a http://url.com] ... [/a] - external link (make quotes around url optional)
  // [[] - [
  // [norss] ... [/norss] - disables syndication

  // positions of the tags within the array
  define ("SDA_TAGNUM_NORSS",      0); //
  define ("SDA_TAGNUM_TABLE",      1);
  define ("SDA_TAGNUM_TR",         2);
  define ("SDA_TAGNUM_TD",         3);
  define ("SDA_TAGNUM_NB",         4); //
  define ("SDA_TAGNUM_HR",         5); //
  define ("SDA_TAGNUM_OL",         6);
  define ("SDA_TAGNUM_UL",         7);
  define ("SDA_TAGNUM_LI",         8);
  //define ("SDA_TAGNUM_X",          9); // obsolete
  define ("SDA_TAGNUM_B",         9);  //
  define ("SDA_TAGNUM_U",         10); //
  define ("SDA_TAGNUM_I",         11); //
  define ("SDA_TAGNUM_MDASH",     12); //
  define ("SDA_TAGNUM_A",         13); //
  define ("SDA_TAGNUM_SQBRACKET", 14); //
  define ("SDA_TAGNUM_S",         15); //
  define ("SDA_TAGNUM_M",         16); //
  define ("SDA_TAGNUM_H",         17); //

  define ("SDA_TAGNUM_NEWLINE",   -1);
  define ("SDA_TAGNUM_CARRIAGE",  -2);

  // the longer tags MUST BE AT THE START

  sda_parser_tagdefs_add('norss',1,0,NULL); // 0
  sda_parser_tagdefs_add('table',1,0,NULL); // 1
  sda_parser_tagdefs_add('tr',0,0,array(0=>SDA_TAGNUM_TABLE)); // 2
  sda_parser_tagdefs_add('td',0,0,array(0=>SDA_TAGNUM_TABLE)); // 3
  sda_parser_tagdefs_add('nb',1,0,NULL); // 4
  sda_parser_tagdefs_add('hr',0,0,NULL); // 5
  sda_parser_tagdefs_add('ol',1,0,NULL); // 6
  sda_parser_tagdefs_add('ul',1,0,NULL); // 7
  sda_parser_tagdefs_add('li',0,0,array(0=>SDA_TAGNUM_OL,1=>SDA_TAGNUM_UL)); // 8
  //sda_parser_tagdefs_add('x',0,1,NULL); // 9 // obsolete
  sda_parser_tagdefs_add('b',1,0,NULL); // 9
  sda_parser_tagdefs_add('u',1,0,NULL); // 10
  sda_parser_tagdefs_add('i',1,0,NULL); // 11
  sda_parser_tagdefs_add('-',0,0,NULL); // 12
  sda_parser_tagdefs_add('a',1,1,NULL); // 13
  sda_parser_tagdefs_add('[',0,0,NULL); // 14
  sda_parser_tagdefs_add('s',1,0,NULL); // 15
  sda_parser_tagdefs_add('m',1,0,NULL); // 16
  sda_parser_tagdefs_add('h',1,0,NULL); // 17

  function sda_parser_tagdefs_add($id, $needs_closing, $extra_data, $master_tags) {
    global $sda_parser_tags;
    $tag=new SDACLS_ParserTag;
    $tag->id=$id;
    $tag->needs_closing=$needs_closing;
    $tag->extra_data=$extra_data;
    $tag->master_tags=$master_tags;
    $sda_parser_tags[]=$tag;
  }

?>
