<?php

/*
  1. Bring data up to date.
  2. Introduce support for cookies.
  3. Improve CSS consistency; offer selectable stylesheets (SDA classic, and also a black-on-white alternative). Make inverted version of banner for the former.
  4. Decide on target HTML/XHTML version, attempt to make bbcode parser W3C compliant.
  5. [?] Implement fuzzy sdaname lookups via URL parameters, to make linking to things easier.
  6. Improve debug mode.
  7. Implement pictures; this can be done now the site is hosted on m2k2.
  8. Finalise design for implementation of update mechanism and history mechanisms.
  9. Abolish release systems. (Delete from db?)
  10. Solve the no surname / no handle class of problems; allow sorting by surname or handle with fallback to the other if not present. Probably requires schema alterations and data duplication.
  11. Make various X_from_db_row() functions into methods on the relevant classes; move the data classes into a separate include file.
  12. Improve filename naming convention.
  13. Improve PHP sanity checks.
  14. Improve database column naming.
  15. Clarify strategy for db localisation support.
  16. Add runner bio display code.
  17. Revise metacategories; patch data accordingly.
  18. Introduce a fourth way of finding SDA content: listing by metacategory.
  19. Investigate alternatives to "(go ->)" links.
  20. Standardise time formatting.
  21. Implement user-selectable date display format via cookie.
  22. Add database fields to store f, d, bitrate and codec for all vidfiles.
  23. Develop software to recover all f, d, bitrate, codec information from FDC, archive.org for all vidfiles on sda2p. See #22.
  24. Improve main / supplementary part naming, remove unnecessary fold-up code for supp parts.
  25. Add persistent option to disable flash player.
  26. [?] Delete FLV from database.
  27. Fix vertical spacing bugs in download lists.
  28. Search SDA and archive for any missing auxiliary parts.
  29. Allow creation of vidfiles that are not attached to a run.
  30. Implement [vf] parser tag for vidfiles; see also #29, this will allow the IL levelset ZIP problem to be solved.
  31. Implement caching mechanism for bbcode parse.
  32. Improve IL table category extraction mechanism such that Max Payne 2 IL displays correctly.
  33. Replace e-mail obfuscation hack with better solution.
  34. Implement BitTorrent linking, including database fields that will be required for auto-rebuilding of torrents from run parts (for full runs) or IL category tuple (for IL runs). Consider to what degree an override mechanism may also be required for these tasks (IL in particular).
  35. Decide upon IL playlist strategy, implement it.
  36. Implement audio commentary.
  37. Improve pagination strategy on systems.php, gamelist.php, person.php.
  38. Investigate improved tooltip CSS.
  39. Game titles on run pages should link to game pages.
  40. Add "<- pick another level" link to IL run pages.
  41. Only display playlist for runs with multiple parts (or IL, if IL category playlists are implemented -- see #35).
  42. Try to improve the layout of run.php such that scrollable comments are "less lame". Consider in-page user control of the way comments are displayed (inline or scrollable, make scroll box size user-selectable? other options? fix flash player on right?)
  43. Try to make all tooltips display "upwards", i.e. with their bottom edge relative to the tooltip position.
  44. "Runner commentary" is confusing.
  45. Make video flavour tooltips less confusing; see #22 and #23.
  46. Fix OoT run system (any%, 100% -> GCN).
  47. List mp4 before avi -- any other changes needed to the order in which flavours are displayed? schema change (sort_order)?
  48. Review what is expanded by default and what is collapsed by default under various circumstances on run.php.
  49. Fix "<- back" controls.
  50. Find less verbose strategy for IL lists on system.php; size-dependent? Consider what to do about listing / linking to runs on this page.
  51. Wouter Jansens.
  52. LeCoureur SM64 70-star run.
  53. Add some links to VLC somewhere.
  54. Improve naming within source code; see also #14.
  55. Investigate possibly incorrect system.php ordering (Zelda).
  56. Write proper descriptions for global categories (there are currently seven of these: SS, 100%, death abuse, save warping, EU version, JP version, and scripts).
  57. Add bad vidfiles to the vidfile notes.
*/

  if (!defined("SDA_VALIDENTRY")) {
    die();
  }

  require_once("configure_me.php");

  define ("SDA_PAGINATION", 30);

//  define ("SDA_FLAVOUR_ID_FLASH", 16); // was flv ...
  define ("SDA_FLAVOUR_ID_FLASH", 12); // now NQ mp4.

  define ("SDA_GAME_REDIR_MAX", 10);
  define ("SDA_RUN_REDIR_MAX",  10);

  define ("SDA_MIRROR_ID_ARCHIVE",       -1);
  define ("SDA_MIRROR_ID_FLASH_DEFAULT",  -1); // archive

  define ("SDA_ARCHIVE_BACKUP_SERVER_MODE_PRIMARY", 1);
  define ("SDA_ARCHIVE_BACKUP_SERVER_MODE_BACKUP",  2);
  define ("SDA_ARCHIVE_BACKUP_SERVER_MODE_RANDOM",  3);
  define ("SDA_ARCHIVE_BACKUP_SERVER_MODE_CHOOSE",  4);
  
  // sda_get_mirrors() modes (flavour keyed or mirror keyed?):
  define ("SDA_MIRROR_FIRST",  0);
  define ("SDA_FLAVOUR_FIRST", 1);
  define ("SDA_MK_THEN_FK",    2);

  define ("SDA_CSS_BOLD",    "sda_b");
  define ("SDA_CSS_ULINE",   "sda_u");
  define ("SDA_CSS_ITAL",    "sda_i");
  define ("SDA_CSS_HEADING", "sda_h");
  define ("SDA_CSS_STRIKE",  "sda_s");
  define ("SDA_CSS_DEFAULT", "sda");
  
  define ("SDA_IX_MAIN_PARTS", 0);
  define ("SDA_IX_SUPP_PARTS", 1);
  define ("SDA_IX_BOAT_PARTS", 2); // not used
  
  define ("SDA_ROWCOL1", "ccffcc");
  define ("SDA_ROWCOL2", "ccccff");
  
  define ("SDA_HTML_LINKBAR", "<br><div style=\"width:700px\"><div align=\"center\">".
                              " <span class=\"".SDA_CSS_DEFAULT."\">".
                              "<a href=\"gamelist.php\">game list</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".
                              "<a href=\"person.php\">runner list</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".
                              "<a href=\"system.php\">system list</a></span></div></div>");

  $sda_conn=NULL;

  srand(time());

  // constant can be defined to disable database connection
  // for standalone scripts that don't use mysql
  if (!defined("SDA_MYSQL_AUTOCONNECT")||SDA_MYSQL_AUTOCONNECT===1) {
    sda_mysql_connect();
  }
//  sda_prof_begin($event);
  //sda_prof_end($event);

  if (get_magic_quotes_gpc()) {
    foreach($_GET as $k=>$v)  { $_GET[$k]=stripslashes($v);  }
    foreach($_POST as $k=>$v) { $_POST[$k]=stripslashes($v); }
  }

  $sda_xmlconv=array("&" =>"&amp;",
                     "'" =>"&apos;",
                     "\""=>"&quot;",
                     ">" =>"&gt;",
                     "<" =>"&lt;");

  function sda_xmlentities($i) {
    global $sda_xmlconv;
    return strtr($i,$sda_xmlconv);
  }

  function sda_mysql_connect() {
    global $sda_conn;
    if (FALSE===($sda_conn=@mysql_connect("localhost",SDA_MYSQL_USER,SDA_MYSQL_PASS))
        || $sda_conn===NULL) {
      sda_die ("database: epic fail");
    }
    if (FALSE===mysql_select_db(SDA_MYSQL_DB,$sda_conn)) {
      sda_die ("select db: epic fail");
    }
  }

  $sda_qlog=NULL;
  $sda_plog=NULL;
  $sda_prof_elist=NULL;

  function sda_prof_begin($event) {
    global $sda_plog, $sda_prof_elist;
    if (SDA_PLOG_MODE===SDA_PLOG_NONE) { return; }
    if (!isset($event)||$event==="") { return; }
    if (SDA_PLOG_MODE===SDA_PLOG_FILE) {
      if (!isset($sda_plog)) {
        if (FALSE===($sda_plog=@fopen(SDA_PLOG, "ab"))) {
          $sda_plog=NULL;
        } else {
          fwrite($sda_plog,"---\n");
        }
      }
    } else {
      global $sda_conn;
      $sda_plog=FALSE; // for database logging
    }
    if (!isset($sda_prof_elist)) {
      $sda_prof_elist=array();
    }
    //$event=basename($_SERVER['SCRIPT_FILENAME'])."|".$event;
    if (isset($sda_plog)) {
      $uid=$_SERVER['REMOTE_ADDR'].":".$_SERVER['REMOTE_PORT'];
      if (!isset($sda_prof_elist[$uid])) {
        $sda_prof_elist[$uid]=array();
      }
      if (isset($sda_prof_elist[$uid][$event])) {
        $s="W: sda_prof_begin(\"".$event."\"): already running, ignored.";
        if (SDA_PLOG_MODE===SDA_PLOG_FILE) {
          // file
          fwrite($sda_plog,$s);
        } else {
          // database
          if (strlen($s)>255) { $s=substr($s,0,255); }
          $q="insert into plog values(NULL,NULL,'".sda_addslashes($s)."',NULL)";
          mysql_query($q, $sda_conn);
        }
      } else {
        $sda_prof_elist[$uid][$event]=(float)microtime(TRUE);
      }
    }
  }
  
  function sda_prof_end($event) {
    global $sda_plog, $sda_prof_elist;
    if (SDA_PLOG_MODE===SDA_PLOG_NONE) { return; }
    if (!isset($event)||$event==="") { return; }
    if (SDA_PLOG_MODE===SDA_PLOG_FILE) {
      if (!isset($sda_plog)) {
        if (FALSE===($sda_plog=@fopen(SDA_PLOG, "ab"))) {
          $sda_plog=NULL;
        } else {
          fwrite($sda_plog,"---\n");
        }
      }
    } else {
      // db mode
      global $sda_conn;
      $sda_plog=FALSE;
    }
    if (!isset($sda_prof_elist)) {
      $sda_prof_elist=array();
    }
    //$event=basename($_SERVER['SCRIPT_FILENAME'])."|".$event;
    if (isset($sda_plog)) {
      $uid=$_SERVER['REMOTE_ADDR'].":".$_SERVER['REMOTE_PORT'];
      if (!isset($sda_prof_elist[$uid])) {
        $sda_prof_elist[$uid]=array();
      }
      if (!isset($sda_prof_elist[$uid][$event])) {
        $s="W: sda_prof_end(\"".$event."\"): event not found, ignored.";
        if (SDA_PLOG_MODE===SDA_PLOG_FILE) {
          fwrite($sda_plog,$s);
        } else {
          if (strlen($s)>255) { $s=substr($s,0,255); }
          $q="insert into plog values(NULL,NULL,'".sda_addslashes($s)."',NULL)";
          mysql_query($q, $sda_conn);
        }
      } else {
        $t=((float)microtime(TRUE))-((float)$sda_prof_elist[$uid][$event]);
        $t=number_format($t,5);
        $sda_prof_elist[$uid][$event]=NULL;
        $bn=basename($_SERVER['SCRIPT_FILENAME']);
        $qs=$_SERVER['QUERY_STRING'];
        if (SDA_PLOG_MODE===SDA_PLOG_FILE) {
          fwrite($sda_plog,$bn."|".$qs."|".strtr($event,array("|"=>"?"))."|".$t."\n");
        } else {
          if (strlen($bn)>64)  { $bn=substr($bn,0,64); }
          if (strlen($qs)>255) { $qs=substr($qs,0,255); }
          if (strlen($event)>255) { $event=substr($event,0,255); }
          $q="insert into plog values('".
             sda_addslashes($bn)."','".
             sda_addslashes($qs)."','".
             sda_addslashes($event)."',".
             $t.")";
          mysql_query($q, $sda_conn);
        }
      }
    }
  }
  
  /*
  function sda_prof_begin($event) {
    global $sda_plog, $sda_prof_elist;
    if (!SDA_PROF) { return; }
    if (!isset($event)||$event=="") { return; }
    if (!isset($sda_plog)) {
      if (FALSE===($sda_plog=@fopen(SDA_PLOG, "ab"))) {
        $sda_plog=NULL;
      } else {
        fwrite($sda_plog,"---\n");
      }
    }
    if (!isset($sda_prof_elist)) {
      $sda_prof_elist=array();
    }
    //$event=basename($_SERVER['SCRIPT_FILENAME'])."|".$event;
    if (isset($sda_plog)) {
      $uid=$_SERVER['REMOTE_ADDR'].":".$_SERVER['REMOTE_PORT'];
      if (!isset($sda_prof_elist[$uid])) {
        $sda_prof_elist[$uid]=array();
      }
      if (isset($sda_prof_elist[$uid][$event])) {
        fwrite($sda_plog,"W: sda_prof_begin(\"".$event."\"): already running, ignored.\n");
      } else {
        $sda_prof_elist[$uid][$event]=(float)microtime(TRUE);
      }
    }
  }
  
  function sda_prof_end($event) {
    global $sda_plog, $sda_prof_elist;
    if (!SDA_PROF) { return; }
    if (!isset($event)||$event=="") { return; }
    if (!isset($sda_plog)) {
      if (FALSE===($sda_plog=@fopen(SDA_PLOG, "ab"))) {
        $sda_plog=NULL;
      } else {
        fwrite($sda_plog,"---\n");
      }
    }
    if (!isset($sda_prof_elist)) {
      $sda_prof_elist=array();
    }
    //$event=basename($_SERVER['SCRIPT_FILENAME'])."|".$event;
    if (isset($sda_plog)) {
      $uid=$_SERVER['REMOTE_ADDR'].":".$_SERVER['REMOTE_PORT'];
      if (!isset($sda_prof_elist[$uid])) {
        $sda_prof_elist[$uid]=array();
      }
      if (!isset($sda_prof_elist[$uid][$event])) {
        fwrite($sda_plog,"W: sda_prof_end(\"".$event."\"): event not found, ignored.\n");
      } else {
        $t=((float)microtime(TRUE))-((float)$sda_prof_elist[$uid][$event]);
        $t=number_format($t,5);
        $sda_prof_elist[$uid][$event]=NULL;
        $bn=basename($_SERVER['SCRIPT_FILENAME']);
        fwrite($sda_plog,$bn."|".strtr($event,array("|"=>"?"))."|".$t."\n");
      }
    }
  }
  */
  
  function sda_mysql_query($q) {
    global $sda_qlog;
    global $sda_conn;
    if (SDA_QLOG) {
      if (!isset($sda_qlog)) {
        $sda_qlog=fopen(SDA_QLOG, "ab");
        fwrite($sda_qlog,"=== ".basename($_SERVER['SCRIPT_FILENAME']).":\n");
      }
      if ($sda_qlog) {
        fwrite($sda_qlog,$q."\n");
      }
    }
    $r=mysql_query($q,$sda_conn);
    if ($r===FALSE) {
      sda_die("query \"".$q."\" failed: ".mysql_error($sda_conn));
    }
    return $r;
  }
  
  function sda_die($s) {
    // add logging functionality ...
    // removed call to sda_htmlentities(), since it is defined in inc_parser,
    // and we can't guarantee that that has been included.
    //die("<p>".sda_htmlentities($s)."</p>");
    die("<p>".htmlspecialchars($s)."</p>");
  }
  
  function sda_warn($s) {
    // FIXME: do something with the errmsg
  }
  
  function build_run_line_html_2(/*$categories,*/ // use clist_by_ix list inside run object now
                                 $run,
                                 /*$runners,*/ // use plist_by_ix list inside run object now
                                 $show_link_and_bullets) {
    $op="";
    if (!isset($run)) { sda_die ("build_run_line_html_2(): run is NULL."); }
    if (!isset($run->clist_by_ix)) { sda_die ("build_run_line_html_2(): run->clist_by_ix unset"); }
    if (!isset($run->plist_by_ix)) { sda_die ("build_run_line_html_2(): run->plist_by_ix unset"); }
    if (!is_array($run->clist_by_ix)) {
      sda_die("build_run_line_html_2(): run->clist_by_ix has type ".gettype($run->clist_by_ix).
          ", should be array.\n");
    }
    if (!is_array($run->plist_by_ix)) {
      sda_die("build_run_line_html_2(): run->plist_by_ix has type ".gettype($run->plist_by_ix).
          ", should be array.\n");
    }
    // FIXME: check type of $run
  
    $i=0;
    if ($show_link_and_bullets) { $op.= "<li>"; }
    //$run_id=(integer)$run_id;
    //$segs=(integer)$segs;
    //$time_format=(integer)$time_format;
    //$time_ms=(integer)$time_ms;
    $op.="<span class=\"".SDA_CSS_DEFAULT."\">";
    if ($run->is_il) {
      // for IL runs, we want to print the level names.
      // note that this isn't used by game.php, which uses
      // its own code to render the IL table -- this is
      // only used by run.php:
//print_r($run);print "<br><br>";
      $op.="<span class=\"".SDA_CSS_BOLD."\">Level:</span> ";
      $op.=sda_htmlentities($run->level_name_1);
      if (isset($run->level_name_2)) {
        $op.=", ".sda_htmlentities($run->level_name_2);
      }
      $op.="<br>";
    }
    foreach ($run->clist_by_ix as $blah=>$cat) {
      if (!$cat->cid) { continue; } // ignore DUMMY NULL CATEGORY
      //$op.= sda_htmlentities($cat->cat_desc_en_us_short);
      $op.=tooltip_category_name($cat);
      $op.= (($i==count($run->clist_by_ix)-1)?" ":", ");
      $i++;
    }
    if ($run->time_ms>0) { // time can be zero for things like pikmin and the zelda MM 6-day challenge
      $op.= "<span class=\"".SDA_CSS_BOLD."\">".
            sda_htmlentities(grenola_format_time($run->time_ms, $run->time_format)).
            "</span>";
    } else {
      $op.= "<span class=\"".SDA_CSS_DEFAULT."\">(untimed)</span>";
    }
    if ($run->num_segs>1) {
      $op.= " in ".$run->num_segs." segments";
    }
    if ($show_link_and_bullets) {
      $op.= " (<a href=\"run.php?run_id=".($run->rid)."\">go &rarr;</a>)";
    }
    // FIXME. This data should be provided by the caller, not looked up here.
    /*
    $q="select people.* ".
       "from people,run_runners ".
       "where people.update_id=0 ".
       "and run_runners.update_id=0 ".
       "and people.person_id=run_runners.person_id ".
       "and run_runners.run_id=".($run_id);
    $runners=sda_rquery($q);
    */
    // Single-runner case: print on same line.
    // multiple runner case is handled later.
    // also, don't print anything for DUMMY NULL RUNNER (0).
    $plist=$run->plist_by_ix;
    if (count($plist)===1) {
      $p=$plist[0];
      if ($p->pid) {
        $op.= ", by ".sda_format_person_name($p);
      }
    }
/*
    print ".&nbsp;&nbsp;&nbsp;<small>(<a href=\"#\" onclick=\"showhide_details(".((integer)$v['run_id']).");return false;\">show/hide details</a>)</small>";
    print "<div id=\"details_".((integer)$v['run_id'])."\" style=\"display:none\">";
*/
    if (isset($run->run_date)) {
      $op.= ", completed on ".sda_htmlentities($run->run_date);
      if (isset($run->date_approx)&&$run->date_approx) {
        $op.=" (date approximate)";
      }
    }

    $op.=".";

    if (isset($run->system_id)) {
      $op.=" Played on <a href=\"system.php?sid=".
           $run->system_id."\">".
           sda_htmlentities($run->system_name).
           "</a>.";
    }

    $op.="</span>";

    // multirunner stuff
    if (count($run->plist_by_ix)>1) {
      $i=0;
      foreach($run->plist_by_ix as $blah=>$runner) {
        if (!$runner->pid) { continue; } // ignore DUMMY NULL RUNNER
        if (!$i) {
          $op.="<span class=\"".SDA_CSS_DEFAULT."\"><br>Runners:</span><ul>";
          $i=1; // only print heading once
        }
        $op.="<li><span class=\"".SDA_CSS_DEFAULT."\">".
             sda_format_person_name($runner).
             "</span></li>";
      }
      $op.="</ul>";
    }
    if ($show_link_and_bullets) { $op.= "</li>"; }
    return $op;
  }
  
  //function tooltip_category_name($c) { print gettype($c); return sda_addslashes($c->cat_desc_en_us_short); }
  
  function tooltip_category_name($c) {

    if (isset($c->cat_desc_en_us_long) && $c->cat_desc_en_us_long!="") {
      $s="<span class=\"sda_tt\">";
      $s.=sda_htmlentities($c->cat_desc_en_us_short);
      $s.="<span class=\"sda_tt_inner\">".sda_parser_wrapper($c->cat_desc_en_us_long)."</span></span>";
    } else if (isset($c->mcat_desc_en_us_long) && $c->mcat_desc_en_us_long!="") {
      $s="<span class=\"sda_tt\">";
      $s.=sda_htmlentities($c->cat_desc_en_us_short);
      $s.="<span class=\"sda_tt_inner\">".sda_parser_wrapper($c->mcat_desc_en_us_long)."</span></span>";
    } else {
      $s="<span class=\"sda\">";
      $s.=sda_htmlentities($c->cat_desc_en_us_short);
      $s.="</span>";
    }
    return $s;
  }
  
  // hack
  function sda_format_person_name($p) {
    return sda_format_person_name_2($p,1,0);
  }
  
  function sda_format_person_name_2($p,$link,$surname_first) {
    if (!isset($p)) { return; }
    $a=array("forenames"=>$p->forenames,
             "handle"=>$p->handle,
             "surname"=>$p->surname,
             "extra"=>$p->extra,
             "person_id"=>$p->pid,
             "alternative"=>$p->alt);
    return sda_format_runner_name_2($a,$link,$surname_first);
  }

  function sda_format_runner_name($row) {
    return sda_format_runner_name_2($row,1,0);
  }

  function sda_format_runner_name_2($row,$link,$surname_first) { // FIXME: use a proper object
    $op="";
    $forenames=$row['forenames'];
    $handle=$row['handle'];
    $surname=$row['surname'];
    $extra=$row['extra'];
    $alt=$row['alternative'];
    if ($link) {
      $op.=" <a href=\"person.php?pid=".((integer)$row['person_id'])."\">";
    }
    $spacer="";
    if ($surname_first) {
      if (isset($surname) && $surname!=="") {
        //$op.=sda_parser_wrapper($surname);
        $op.=sda_htmlentities($surname);
        $spacer=" ";
      }
      if (isset($extra) && $extra!=="") {
        //$op.=$spacer.sda_parser_wrapper($extra);
        $op.=$spacer.sda_htmlentities($extra);
      }
      $spacer=(isset($forenames)&&$forenames!=="")?", ":""; // hack: anonymous runners
    }
    if (isset($forenames) && $forenames!=="") {
      //$op.=$spacer.sda_parser_wrapper($forenames); //,NULL);
      $op.=$spacer.sda_htmlentities($forenames); //,NULL);
      $spacer=" ";
    }
    if (isset($handle) && $handle!=="") {
      //$op.=$spacer."'".sda_parser_wrapper($handle)."'";
      $op.=$spacer."'".sda_htmlentities($handle)."'";
      $spacer=" ";
    }
    if (!$surname_first) {
      if (isset($surname) && $surname!=="") {
        //$op.=$spacer.sda_parser_wrapper($surname);
        $op.=$spacer.sda_htmlentities($surname);
        $spacer=" ";
      }
      if (isset($extra) && $extra!=="") {
        //$op.=$spacer.sda_parser_wrapper($extra);
        $op.=$spacer.sda_htmlentities($extra);
        $spacer=" ";
      }
    }
    if (isset($alt) && $alt!=="") {
      //$op.=$spacer."(".sda_parser_wrapper($alt).")";
      $op.=$spacer."(".sda_htmlentities($alt).")";
    }
    if ($link) { $op.="</a>"; }
/*
    if ($show_num_runs) {
      $nr=(integer)$row['count(run_runners.run_id)'];
      $op.=" (".$nr." run".($nr>1?"s":"").")";
    }
*/
    return $op;
  }

  function grenola_format_time($ms,$format) {

    // FIXME

    //  0: mm:ss.xxx
    //  1: mm:ss.xx
    //  2: mm:ss.x
    //  3: mm:ss
    //  4,5,6,7: hh:mm
    //  8: hh:mm:ss.xxx
    //  9: hh:mm:ss.xx
    // 10: hh:mm:ss.x
    // 11: hh:mm:ss
    // 12: hh:mm

    $op="";
    //$fs="%2.3f";
    $mfs="%d";
    if ($format>3) { // hours
      //$op.=sprintf($fs,floor($ms/(1000*60*60))).":";
      $op.=floor($ms/(1000*60*60)).":";
      $ms-=floor($ms/(1000*60*60))*1000*60*60;
      $mfs="%02d"; // override minute format string
    }
    // always show minutes
    $op.=sprintf($mfs,floor($ms/(1000*60)));
    $ms-=floor($ms/(1000*60))*1000*60;
    if ($format!=12) {
      $op.=":";
      $ms_only=sprintf("%05d",$ms%60000);
      //$fs="%02.f";
      switch ($format) {
        // FIXME: these are totally broken ...
        case 0: case 8:
          $op.=substr($ms_only,0,-3).".".substr($ms_only,-3,3); break;
        case 1: case 9:
          $op.=substr($ms_only,0,-3).".".substr($ms_only,-3,2); break;
        case 2: case 10:
          $op.=substr($ms_only,0,-3).".".substr($ms_only,-3,1); break;
        case 3: case 11:
          $op.=sprintf("%02d",floor($ms_only/1000)); break;
      }
    }
    return $op;
  }

  function sda_game_heading($gamename) {
    print "<h1>".sda_htmlentities($gamename)."</h1>";
  }

  function sda_format_vidlen($vidlen_s) {
    $op=floor($vidlen_s/(60*60)).":";
    $vidlen_s-=floor($vidlen_s/(60*60))*60*60;
    $op.=sprintf("%02d",floor($vidlen_s/(60))).":";
    $vidlen_s-=floor($vidlen_s/(60))*60;
    $op.=sprintf("%02d",$vidlen_s);
    return $op;
  }

  function grenola_php_self_safe () {
    $x=get_magic_quotes_gpc()?stripslashes($_SERVER["PHP_SELF"]):$_SERVER["PHP_SELF"];
    return grenola_url_segment_escape($x);
  }

  function grenola_url_segment_escape ($url_segment) {
    
    // -- RFC 1738 states --
    // Thus, only alphanumerics, the special characters "$-_.+!*'(),", and
    // reserved characters used for their reserved purposes may be used
    // unencoded within a URL.
    // -- and --
    // The characters ";",
    // "/", "?", ":", "@", "=" and "&" are the characters which may be
    // reserved for special meaning within a scheme.

    $len = strlen($url_segment);
    $ret = "";
    for ($i=0;$i<$len;$i++) {
      //if (eregi ("[a-z0-9]", $url_segment[$i])) {
      if (ctype_alnum($url_segment[$i])) {
        $ret .= $url_segment[$i];
      } else {
        // 1.0.1: BG0017
        if ($url_segment[$i] == "&") {
          $ret.="&amp;";
          continue;
        }
        switch ($url_segment[$i]) {
          // note we're encoding ampersands in case of stuff like "http://blah?mens=mens&amp=mens":
          case "$": case "-": case "_": case ".": case "+": case "!": case "*": case "'": case "(":
          case ")": case ",": case "/": case "?": case ":": case "@": case "=": /*case "&":*/ case "#":
            $ret .= $url_segment[$i];
            break;
          default:
            $ret .= urlencode ($url_segment[$i]);
        }
      }
    }
    
    return $ret;
    
  }
  
  function category_from_db_row($row) {
    $c=new SDA_Category;
    if (isset($row['category_id'])) { $c->cid=(integer)$row['category_id']; }
    if (isset($row['metacategory_id'])) { $c->mcid=(integer)$row['metacategory_id']; }
    if (isset($row['cat_desc_en_us_short'])) { $c->cat_desc_en_us_short=$row['cat_desc_en_us_short']; }
    if (isset($row['cat_desc_en_us_long'])) { $c->cat_desc_en_us_long=$row['cat_desc_en_us_long']; }
    if (isset($row['filename_suffix'])) { $c->fn_sfx=$row['filename_suffix']; }
    if (isset($row['mcat_desc_en_us_long'])) { $c->mcat_desc_en_us_long=$row['mcat_desc_en_us_long']; }
    return $c;
  }

  class SDA_Mirror {
    // generic stuff
    var $id;
    var $name;
    // non-archive stuff
    var $base;
    var $use_canonicals;
    // archive-only stuff
    var $primary_hosed;
    var $secondary_hosed;
    var $archive_server;
    var $archive_item;
    var $archive_path;
    var $backup_server_mode;
    // stuff from flavours table:
    var $flav_id;
    var $flav_desc_short;
    var $flav_desc_long;
    var $flav_suffix;
    var $flav_extension;
    var $flav_canonical_sfx;
  }
  
  class SDA_Category {
    var $cid;
    var $mcid;
    var $cat_desc_en_us_short;
    var $cat_desc_en_us_long;
    var $fn_sfx;
    var $mcat_desc_en_us_short;
    var $mcat_desc_en_us_long;
  }
  
  class SDA_Person {
    var $pid;
    var $forenames;
    var $handle;
    var $surname;
    var $extra;
    var $alt;
    var $email;
    var $bio_text;
  }
  
  function sda_get_mirrors_2($rid, $result_mode) {
    // simpler version of sda_get_mirrors(), extended functionality not required since:
    //    i) flv is no longer relevant for flash player;
    //   ii) old demo.php functionality now integrated into run.php, so
    //       single-mirror selection is no longer required
    
    // result mode dictates how the results should be organised.
    // MIRROR_FIRST:
    // array (
    //   [mirror_id]=>array ( [flavid]=>SDA_Mirror, [flavid]=>SDA_Mirror, ... ),
    //   [mirror_id]=>array ( [flavid]=>SDA_Mirror, [flavid]=>SDA_Mirror, ... )
    //   ... etc
    // )

    // FLAVOUR_FIRST:
    // array (
    //   [flavid]=>array ( [mirror_id]=>SDA_Mirror, [mirror_id]=>SDA_Mirror, ... ),
    //   [flavid]=>array ( [mirror_id]=>SDA_Mirror, [mirror_id]=>SDA_Mirror, ... )
    //   ... etc
    // )
    
    // MK_THEN_FK:
    // array (
    //   [0] => as MIRROR_FIRST
    //   [1] => as FLAVOUR_FIRST
    // )
    
    if (!is_numeric($rid)) { return FALSE; }
    $rid=(integer)$rid;
    if ($rid<1) { return FALSE; }
    switch ($result_mode) {
      case SDA_MIRROR_FIRST:
      case SDA_FLAVOUR_FIRST:
      case SDA_MK_THEN_FK:
        break;
      default:
        return FALSE;
    }
//    $q="select * from v_run_flavmirrors where run_id=".$rid;
    //$flavour_mirrors=sda_rquery($q);
    
    /*
    if ($result_mode==SDA_MIRROR_FIRST) {
      $mirrors=array();
    } else {
      $flavours=array();
    }
    */
    $mirrors=array();
    $flavours=array();
    $rno=NULL;
    $q_archive="select ".
                 "*".
               " from ".
                 "archive_runs".
               " where ".
                 "update_id=0".
                 " and run_id=".$rid;
//    $archive_data=sda_rquery($q_archive);
    $r_archive=sda_mysql_query($q_archive);
    if (FALSE==($row_archive=mysql_fetch_assoc($r_archive))) {
      $archive_data=NULL;
    } else {
      $archive_data=$row_archive;
    }
    mysql_free_result($r_archive);
    $hosed_data=NULL;
    $q_flav_mirrors="select ".
                      "run_flavour_mirrors.run_id,".
                      "run_flavour_mirrors.flavour_id,".
                      "run_flavour_mirrors.mirror_id,".
                      "flavours.desc_en_us_short,".
                      "flavours.desc_en_us_long,".
                      "flavours.suffix,".
                      "flavours.extension,".
                      "flavours.canonical_path_suffix,".
                      "mirrors.base,".
                      "mirrors.use_canonical_dirs,".
                      "mirrors.mirror_name,".
                      "runs.run_name_override".
                    " from ".
                      "run_flavour_mirrors,".
                      "mirrors,".
                      "flavours,".
                      "runs".
                    " where ".
                      "run_flavour_mirrors.update_id=0".
                      " and mirrors.update_id=0".
                      " and runs.update_id=0".
                      " and flavours.update_id=0".
                      " and mirrors.mirror_id=run_flavour_mirrors.mirror_id".
                      " and run_flavour_mirrors.run_id=runs.run_id".
                      " and flavours.flavour_id=run_flavour_mirrors.flavour_id".
                      " and runs.run_id=".$rid;
//print $q_flav_mirrors;
    $r_flav_mirrors=sda_mysql_query($q_flav_mirrors);
    //foreach ($flavour_mirrors as $ix=>$row) {
//print "mysql_num_rows(r_flav_mirrors)=".mysql_num_rows($r_flav_mirrors);
//die();
    while (FALSE!==($row_flav_mirrors=mysql_fetch_assoc($r_flav_mirrors))) {
      $m=mirror_from_db_row($row_flav_mirrors);
//print_r($m)."<br><br>";
      if (isset($row_flav_mirrors['run_name_override'])) {
        $run_sdaname=$row_flav_mirrors['run_name_override'];
      }
      if ($m->id==SDA_MIRROR_ID_ARCHIVE) {
        if (!isset($archive_data)) {
          // skip mirror
          continue;
        }
//        $archive_data=$archive_data[0];
        // $m passed by reference -- populate archive fields on $m object:
        if (!archive_from_db_row($archive_data, $run_sdaname, $m)) { return FALSE; }
        $srv = $m->archive_server;
        if (!isset($hosed_data)) { // have we checked for hosed servers yet? only do this once
          $q_archive_hosed="select ".
                             "*".
                           " from ".
                             "archive_hosed".
                           " where ".
                             "us_server in (".
                             $srv.",".($srv+1).
                             ")"; // no update_id on this table
          //$hosed_data=sda_rquery($q);
          $r_archive_hosed=sda_mysql_query($q_archive_hosed);
        }
        while (FALSE!==($row_archive_hosed=mysql_fetch_assoc($r_archive_hosed))) {
          // populate hosed fields on $m object:
          if (!archive_hosed_from_db_row($row_archive_hosed, $m)) { return FALSE; }
        }
        mysql_free_result($r_archive_hosed);
      }
      $fid=(integer)$row_flav_mirrors['flavour_id'];
      if ($result_mode==SDA_MIRROR_FIRST || $result_mode==SDA_MK_THEN_FK) {
        if (!isset($mirrors[$m->id])) {
          $mirrors[$m->id]=array();
        }
        $mirrors[$m->id][$fid]=$m;
      }
      if ($result_mode==SDA_FLAVOUR_FIRST || $result_mode==SDA_MK_THEN_FK) {
        if (!isset($flavours[$fid])) {
          $flavours[$fid]=array();
        }
        $flavours[$fid][$m->id]=$m;
      }
    } // end foreach()
    if ($result_mode==SDA_MIRROR_FIRST) {
      return $mirrors;
    } else if ($result_mode==SDA_FLAVOUR_FIRST) {
      return $flavours;
    } else { // return both
      return array(0=>$mirrors, 1=>$flavours);
    }
  }

  function sda_archive_mirror_logic ($mirror, $unhosed_only, &$use_archive_primary, &$use_archive_backup) { // PBR
    switch ($mirror->backup_server_mode) {
      case SDA_ARCHIVE_BACKUP_SERVER_MODE_PRIMARY: $use_archive_primary=1; break;
      case SDA_ARCHIVE_BACKUP_SERVER_MODE_BACKUP: $use_archive_backup=1; break;
      case SDA_ARCHIVE_BACKUP_SERVER_MODE_RANDOM:
        if ($mirror->primary_hosed || $mirror->secondary_hosed) {
          $use_archive_primary=$use_archive_backup=1;
        } else {
          $use_archive_primary=($use_archive_backup=rand()%2)?0:1;
        }
        break;
      case SDA_ARCHIVE_BACKUP_SERVER_MODE_CHOOSE: $use_archive_primary=$use_archive_backup=1; break;
    }
    if ($unhosed_only) {
      if ($mirror->primary_hosed && $use_archive_primary) { $use_archive_primary=0; }
      if ($mirror->secondary_hosed && $use_archive_backup) { $use_archive_backup=0; }
    }
  }

  function sda_addslashes($s) {
    // use this wrapper instead of native addslashes() just in case of UTF-8 problems.
    return addslashes($s);
  }

  function sda_get_parts_split($rid,$count_only) {
    //global $sda_conn;
	  //if (!isset($count_only)) { $count_only = 0; } /* legacy hack */
    if (!isset($count_only)) { sda_die("sda_get_parts_split(): count_only is NULL"); }
    $rid=(integer)$rid;
    $q="select ".($count_only?"count(*)":"*")." from run_parts ".
       "where update_id=0 ".
       "and run_id=".$rid." ".
       "and is_supplementary=0 ".
       (!($count_only)?"order by part":"");
//print $q."<br>";
    $r=sda_mysql_query($q);
    if (!$count_only) {
      $main_parts=array();
      while (FALSE!==($x=mysql_fetch_assoc($r))) {
        $main_parts[(integer)$x['part_id']]=$x;
      }
    } else {
      if (FALSE===($x=mysql_fetch_assoc($r))) {
        mysql_free_result($r);
        return FALSE;
      }
      $main_count=(integer)$x['count(*)'];
    }
    mysql_free_result($r);
    $q="select ".($count_only?"count(*)":"*")." from run_parts ".
       "where update_id=0 ".
       "and run_id=".$rid." ".
       "and is_supplementary=1 ".
       (!($count_only)?"order by part":"");
//print $q."<br>";
    $r=sda_mysql_query($q);
    if (!$count_only) {
      $supp_parts=array();
      while (FALSE!==($x=mysql_fetch_assoc($r))) {
        $supp_parts[(integer)$x['part_id']]=$x;
      }
    } else {
      if (FALSE===($x=mysql_fetch_assoc($r))) {
        mysql_free_result($r);
        return FALSE;
      }
      $supp_count=(integer)$x['count(*)'];
    }
    mysql_free_result($r);
    if (!$count_only) {
      return array(0=>$main_parts,1=>$supp_parts);
    } else {
      return array(0=>$main_count,1=>$supp_count);
    }
  }
  

  class SDA_Vidfile {
    var $vidfile_id;
    var $canonical_path;
    var $filename;
    var $part_id;
    var $suffix;
    var $extension;
    var $overrides; // an array, keyed by mirror id
    
    // some extra useful fields from runs table
    var $run_is_il;
    var $run_level_name_1;
    var $run_level_name_2;
    var $run_num_parts;
    //var $run_owner_sdaname;
    
    // some useful extra fields from flavours table
    var $flav_id;
    var $flav_desc_en_us_long;
    var $flav_desc_en_us_short;
    
    // some useful extra fields from run_parts table
    var $vidlen_s;
    var $is_supp;
  }

  class SDA_Vidfile_Override {
    var $mirror_id;
    var $url;
    var $link_text;
  }


  function sda_get_vidfiles($run_id,$flash_only,$key_by_part) {
    return sda_get_vidfiles_2($run_id,$flash_only,$key_by_part,NULL,NULL,NULL);
  }

  // FIXME
  // this is inefficient, because it does a double-copy.
  // make it use the result set instead.
  // FIXME: allow the user to bypass the first query by passing
  // a populated $run object in (run.php already has one)
  
  function sda_get_vidfiles_2($run_id,
                              $flash_only,
                              $key_by_part,
                              $run,
                              $main_parts_count,
                              $supp_parts_count) {
  
    // calling this with key_by_part=1 is for flash only.
	// since there are multiple vidfiles per part, this function
	// currently can only return one vidfile per part (usually LQ)
	// if key_by_part is set. For flash of course this isn't a problem
	// since we only select one vidfile (flv) per part from the query.
	  
//print "sda_get_vidfiles()<br>";
    if (!is_numeric($run_id) || ($run_id=((integer) $run_id))<1) {
      return FALSE;
    }
    /*
    $q="select runs.run_name_override,games.sdaname ".
       "from runs,games ".
       "where runs.update_id=0 ".
       "and games.update_id=0 ".
       "and runs.game_id=games.game_id ".
       "and runs.run_id=".$run_id;
    */
    if (!isset($run)) { // if we aren't given a populated $run object, make one
      //$q="select run_name_override, sdaname, is_il ".
      //   "from v_runs where run_id=".$run_id;
      $q_run="select ".
               /*
               "runs.run_id,".
               "runs.redir_run_id,".
               "runs.game_id,".
               "runs.notes,".
               "runs.comments,".
               "runs.date_is_approx,".
               "runs.time_ms,".
               "runs.time_format,".
               */
               "runs.run_name_override,".
               /*
               "runs.segments,".
               */
               "runs.is_il,".
               /*
               "DATE_FORMAT(runs.date,'%e %M %Y') as run_date,".
               "games.catalogue_name_en_us,".
               "games.name_en_us,".
               "games.redir_game_id,".
               */
               "games.sdaname ".
               /*
               "systems.system_id,".
               "systems.system_name".
               */
             " from ".
               "runs,".
               /*
               "systems".
               */
               "games".
             " where ".
               "runs.update_id=0".
               /*
               "and systems.update_id=0".
               */
               " and games.update_id=0".
               /*
               "and systems.system_id=runs.system_id".
               */
               " and runs.game_id=games.game_id".
               " and runs.run_id=".$run_id;
//      $run_rows=sda_rquery($q);
      $r_run=sda_mysql_query($q_run);
      if (FALSE===($row_run=mysql_fetch_assoc($r_run))) { return FALSE; }
      $run_name=$row_run['run_name_override'];
      $gamename=$row_run['sdaname'];
      $is_il=$row_run['is_il'];
    } else {
      $run_name=$run->run_name;
      $gamename=$run->game_sdaname;
      $is_il=$run->is_il;
    }
    //unset($run);

    $op=array();
//    $q="select * from v_vidfiles".
//       " where run_id=".$run_id;


	
//print "sda_get_vidfiles(): query returns ".count($vidfiles)." results.<br>";

    if (!isset($main_parts_count)||!isset($supp_parts_count)) {
      if (FALSE===($womg=sda_get_parts_split($run_id,1))) { // 1=count only
        return FALSE;
      }
      $mainpart_count=$womg[0];
      $allparts_count=$womg[1]+$womg[0]; // main plus supplementary
    } else {
      $mainpart_count=$main_parts_count;
      $allparts_count=$main_parts_count+$supp_parts_count;
    }
    $fmtstg="%0".strlen($allparts_count)."d";

    /*
    $i=0;
    $in_query="";
    foreach ($vidfiles as $k=>$v) {
      if ($i!=0) { $in_query.=","; }
      $in_query.=((integer)$v['vidfile_id']);
      $i++;
    }
    $q="select vidfile_id,mirror_id,url,link_text ".
       "from mirrors_vidfiles_override ".
       "where update_id=0 ".
       "and vidfile_id in (".$in_query.")";
    */
    
    // get the override data for this run.
    // this routine produces an array like [vidfile_id][mirror_id]=override
/*
    $q="select * from v_vidfile_overrides ".
       " where run_id=".$run_id;
    if ($flash_only) {
      $q.=" and flavour_id=".SDA_FLAVOUR_ID_FLASH;
    }
*/
    $q_overrides="select ".
                 "vidfiles.flavour_id,".
                 "vidfiles.vidfile_id,".
                 "run_parts.run_id,".
                 "mirrors_vidfiles_override.mirror_id,".
                 "mirrors_vidfiles_override.url,".
                 "mirrors_vidfiles_override.link_text".
               " from ".
                 "run_parts,".
                 "part_vidfiles,".
                 "vidfiles,".
                 "mirrors_vidfiles_override".
               " where ".
                 "part_vidfiles.update_id=0".
                 " and run_parts.update_id=0".
                 " and mirrors_vidfiles_override.update_id=0".
                 " and vidfiles.update_id=0".
                 " and run_parts.run_id=".$run_id.
                 " and part_vidfiles.part_id=run_parts.part_id".
                 " and vidfiles.vidfile_id=part_vidfiles.vidfile_id".
                 " and mirrors_vidfiles_override.vidfile_id=vidfiles.vidfile_id";
    if ($flash_only) {
      $q_overrides.=" and flavour_id=".SDA_FLAVOUR_ID_FLASH;
    }
    //$q.= " order by run_parts.part";
sda_prof_begin("[common] q_overrides");
    //$overrides_tmp=sda_rquery($q);
    $r_overrides=sda_mysql_query($q_overrides);
sda_prof_end("[common] q_overrides");
    $overrides=array();
    //foreach ($overrides_tmp as $k=>$v) {
    while (FALSE!==($row_overrides=mysql_fetch_assoc($r_overrides))) {
      $mid=(integer)$row_overrides['mirror_id'];
      if (!isset($overrides[$mid])) { $overrides[$mid]=array(); }
      $oride=new SDA_Vidfile_Override;
      $oride->mirror_id=$mid;
      // NULL url -> remove entry for that mirror ...
      $oride->url=NULL;
      if (isset($row_overrides['url'])&&$row_overrides['url']!=="") {
        $oride->url=$row_overrides['url'];
      }
      $oride->link_text=(integer)$row_overrides['link_text'];
      $overrides[(integer)$row_overrides['vidfile_id']][$mid]=$oride;
    }
    unset($overrides_tmp);

    $q_vidfiles="select ".
                  "flavours.suffix,".
                  "flavours.extension,".
                  "flavours.flavour_id,".
                  "flavours.desc_en_us_short,".
                  "flavours.desc_en_us_long,".
                  "vidfiles.filename_override,".
                  "vidfiles.vidfile_id,".
                  "part_vidfiles.part_id,".
                  "vidfiles.md5sum,".
                  "vidfiles.filesize,".
                  "run_parts.part,".
                  "run_parts.is_supplementary,".
                  "run_parts.is_ending,".
                  "run_parts.name,".
                  "run_parts.run_id,".
                  "run_parts.vidlen_s".
                " from ".
                  "part_vidfiles,".
                  "run_parts,".
                  "flavours,".
                  "vidfiles".
                " where ".
                  "part_vidfiles.update_id=0".
                  " and run_parts.update_id=0".
                  " and flavours.update_id=0".
                  " and vidfiles.update_id=0".
                  " and run_parts.run_id=".$run_id.
                  " and part_vidfiles.part_id=run_parts.part_id".
                  " and vidfiles.vidfile_id=part_vidfiles.vidfile_id".
                  " and vidfiles.flavour_id=flavours.flavour_id";
    if ($flash_only) {
      $q_vidfiles.=" and flavours.flavour_id=".SDA_FLAVOUR_ID_FLASH;
    }
    $q_vidfiles.= " order by run_parts.part";
  
sda_prof_begin("[common] q_vidfiles");
    //$vidfiles=sda_rquery($q);
    $r_vidfiles=sda_mysql_query($q_vidfiles);
sda_prof_end("[common] q_vidfiles");
    if (!mysql_num_rows($r_vidfiles)) {
      return array(); // empty set
    }

sda_prof_begin("build vidfiles array");
    //foreach ($vidfiles as $k=>$v) {
    while (FALSE!==($row_vidfiles=mysql_fetch_assoc($r_vidfiles))) {
      // FIXME: do we want to make a sda_vidfile_from_db_row() function?
      $vf=new SDA_Vidfile;
      //$x->run_is_il=$run[0]['is_il'];
      $vf->run_is_il=$is_il;
      // strat:
      // sdaname_quality_partXX.EXT
      // or
      // sdaname_ending_quality.EXT
      $vf->part_id=(integer)$row_vidfiles['part_id'];
      $vf->vidfile_id=(integer)$row_vidfiles['vidfile_id'];
      $vf->flav_id=(integer)$row_vidfiles['flavour_id'];
      $vf->flav_desc_en_us_short=$row_vidfiles['desc_en_us_short'];
      $vf->flav_desc_en_us_long=$row_vidfiles['desc_en_us_long'];
      $vf->is_supp=$row_vidfiles['is_supplementary'];
      //$x->run_owner_sdaname=$v['run_name_override'];
      if (isset($row_vidfiles['vidlen_s'])) {
        $vf->vidlen_s=(integer)$row_vidfiles['vidlen_s'];
      }
      if (isset($row_vidfiles['md5sum'])) {
        $vf->md5sum=$row_vidfiles['md5sum'];
      }
      if (isset($row_vidfiles['filesize'])) {
        $vf->filesize=$row_vidfiles['filesize'];
      }
      if (!$vf->run_is_il) {
        $vf->canonical_path=$run_name;
      } else {
        // for IL, we use the game name rather than the run name for canonical path
        // (plus flavour extension)
        $vf->canonical_path=$gamename;
      }
      /*
      if (isset($v['suffix']) && $v['suffix']!="") {
        $x->canonical_path.="_".$v['suffix'];
      }
      */
      /*
      if (isset($v['canonical_path_sfx'])) {
        $x->canonical_path.="_".$v['canonical_path_sfx'];
      }
      */
      //$x->canonical_path=$run_name.(isset($v['suffix'])&&$v['suffix']!="")?("_".$v['suffix']):"");
      $vf->overrides=array();
      if (isset($overrides[$vf->vidfile_id])) {
        $ignore=0;
        foreach ($overrides[$vf->vidfile_id] as $blah=>$override) { // loop for each mirror
          //$oride=$v2;
/*
          if ($v2->url===NULL) {
            $ignore=1;
            break;
          }
*/
          $vf->overrides[$override->mirror_id]=$override;
        }
        //if ($ignore) { continue; } // disable mirror case -- ignore this file and keep looping
      }
      if (isset($row_vidfiles['suffix'])) {
        $vf->suffix=$row_vidfiles['suffix'];
      }
      $vf->extension=$row_vidfiles['extension'];
      $sfx=(isset($vf->suffix)&&$vf->suffix!="")?("_".$vf->suffix):"";
      if (isset($row_vidfiles['filename_override']) && $row_vidfiles['filename_override']!=="") {
        $vf->filename=$row_vidfiles['filename_override'];
      } else {
        if ($mainpart_count==1) {
          //$x->filename=$x->canonical_path.".".$v['extension'];
          $vf->filename=$run_name.$sfx.".".$row_vidfiles['extension'];
        } else {
          if ($row_vidfiles['is_ending']) {
            $vf->filename=$gamename."_ending".$sfx.".".$row_vidfiles['extension'];
          } else {
            //$x->filename=$x->canonical_path."_part".sprintf($fmtstg,(integer)$v['part']).".".$v['extension'];
            $vf->filename=$run_name.$sfx.
                         "_part".
                         sprintf($fmtstg,(integer)$row_vidfiles['part']).
                         ".".
                         $row_vidfiles['extension'];
          }
        }
      }
      if ($key_by_part) {
        $key=(integer)$row_vidfiles['part_id'];
      } else {
        $key=(integer)$row_vidfiles['vidfile_id'];
      }
      $op[$key]=$vf;
	  //print_r ($x); print "<br>";
    }
sda_prof_end("build vidfiles array");
	//print "sda_get_vidfiles() returns ".count($op)." results<br>";
    return $op;
  }

  function sda_part_name ($num_main_parts, $part_name_from_db, $partnum) {
    $partnum=(integer)$partnum;
    if (isset($part_name_from_db) && $part_name_from_db!="") {
      return $part_name_from_db;
    }
    if ($num_main_parts==1) { return "Video"; }
    return ("part ".$partnum);
  }
  
  class SDA_Vidfile_Link {
    var $vidfile_id;
    var $mirror_id;
    var $url;
    var $name;
    var $description;
    var $archive_backup;
    var $md5sum;
    var $filesize;
    
    // additional flavour data:
    var $flav_id;
    var $flav_desc_en_us_long;
    var $flav_desc_en_us_short;
    
    // additional part data:
    var $is_supp;
  }

  // NOTE: num_parts should count main parts only
  function sda_build_vidfile_links_2($mirrors_fk, $vidfile_list, $num_main_parts) {

    // returns 5D array: [Y][flavour][part][mirror][X]
    //   -- Y may be 0 for main parts or 1 for supp parts
    //   -- X may be 0 or 1 for one of two possible archive mirrors (0 elsewhere)

    // FIXME: there is no code to populate $link->name and $link->description
    //        for non-overridden cases

    $links=array();

    foreach ($vidfile_list as $vfid=>$vidfile) {
      if (!isset($mirrors_fk[$vidfile->flav_id])) {
        sda_warn("mirrors_fk[".$vidfile->flav_id."] not set: no mirror for vf ".$vfid);
        continue; // no mirror for this vidfile
      }
      $mirrors=$mirrors_fk[$vidfile->flav_id]; // yields array like $mirrors[mirror_id]=>m
      // sanity check for broken database:
      if (!isset($mirrors) || !is_array($mirrors)) { continue; }
      foreach ($mirrors as $mrid=>$mirror) {

        // potentially need up to two links to deal with two archive servers:
        $link1=new SDA_Vidfile_Link;
        $link2=new SDA_Vidfile_Link;
        $j=0;

        // copy some stuff into the SDA_Vidfile_Link objects (this is not currently used)
        $link1->flav_id = $link2->flav_id = $vidfile->flav_id;
        $link1->flav_desc_en_us_long = $link2->flav_desc_en_us_long = $vidfile->flav_desc_en_us_long;
        $link1->flav_desc_en_us_short = $link2->flav_desc_en_us_short = $vidfile->flav_desc_en_us_short;
        $link1->vidfile_id = $link2->vidfile_id = $vfid;
        $link1->mirror_id = $link2->mirror_id = $mrid; // remember, -1 means archive
        $link1->is_supp=$link2->is_supp = $vidfile->is_supp;
 
        if (isset($vidfile->overrides)
            &&count($vidfile->overrides)
            &&isset($vidfile->overrides[$mirror->id])) {
          $oride=$vidfile->overrides[$mirror->id];
          if ($oride->url===NULL) { // NULL url override case
            // disable this mirror for this file
            // (just don't do anything)
            continue;
          } else {
            $link1->url=$oride->url;
            $link1->name=$oride->link_text; // only one object is provided if an archive server is overridden, which (kind of) makes sense
            $j++;
          }
        } else {
          if ($mrid===SDA_MIRROR_ID_ARCHIVE) {
            sda_archive_mirror_logic($mirror, 1, $use_archive_primary, $use_archive_backup); // pass by reference ... 1=not hosed only
            if (isset($mirror->archive_item)) {
              for ($i=0;$i<2;$i++) { // loop: primary, secondary archive servers
                if (!$i&&!$use_archive_primary) { $link1=NULL; continue; }
                if ($i&&!$use_archive_backup)   { $link2=NULL; continue; }
                $j++;
                $server=($mirror->archive_server+$i);
                //if (!($i?$mirror->secondary_hosed:$mirror->primary_hosed)) { // hosed stuff is now dealt with by sda_archive_mirror_logic()
                  if ($i==0) {
                    $link1->url="http://ia".$server.".us.archive.org/".$mirror->archive_path."/".$mirror->archive_item."/".$vidfile->filename;
                    $link1->archive_backup=0;
                  } else {
                    $link2->url="http://ia".$server.".us.archive.org/".$mirror->archive_path."/".$mirror->archive_item."/".$vidfile->filename;
                    $link2->archive_backup=1;
                  }
                //}
              }
              // hack: if link2 populated and link1 not, swap them:
			        if (!isset($link1) && $link2) { $link1=$link2; unset($link2); }
            } else { // fallback case, no direct linking
              $link1->url="http://www.archive.org/download/".$arcitem."/".$vidfile->filename;
            }
          } else { // not archive
//print $vidfile->canonical_path."<br>";
            // assume canonical paths don't do anything for flv
            //$link1->url=($mirror->base).($vidfile->flavour_id==SDA_FLAVOUR_ID_FLASH?"":$vidfile->canonical_path)./*"/".*/($vidfile->filename);
            //$link1->url=($mirror->base).($vidfile->canonical_path).($vidfile->filename);
            $frag="";
            // servers that use the canonical torrent-style dirs:
            //print "num_parts=$num_parts<br>";
            if ($mirror->use_canonicals && ($num_main_parts>1 || $vidfile->run_is_il)) {
              $frag=$vidfile->canonical_path;
              if (isset($mirror->flav_canonical_sfx) && $mirror->flav_canonical_sfx!="") {
                $frag.="_".($mirror->flav_canonical_sfx);
              }
              $frag.="/";
            }
//die($frag);
            $link1->url=($mirror->base).($frag).($vidfile->filename);
            $j++;
          }
        }
		
		//print "j=$j<br>";

        for ($i=0;$i<$j;$i++) {
          $link=$i?$link2:$link1;
          if (!isset($links[$vidfile->is_supp])) {
            $links[$vidfile->is_supp]=array();
          }
          if (!isset($links[$vidfile->is_supp][$vidfile->flav_id])) {
            $links[$vidfile->is_supp][$vidfile->flav_id]=array();
          }
          if (!isset($links[$vidfile->is_supp][$vidfile->flav_id][$vidfile->part_id])) {
            $links[$vidfile->is_supp][$vidfile->flav_id][$vidfile->part_id]=array();
          }
          if (!isset($links[$vidfile->is_supp][$vidfile->flav_id][$vidfile->part_id][$mrid])) {
            $links[$vidfile->is_supp][$vidfile->flav_id][$vidfile->part_id][$mrid]=array();
          }
//print_r($link);
          $links[$vidfile->is_supp][$vidfile->flav_id][$vidfile->part_id][$mrid][]=$link;
		  //print_r ($link); print "<br>";
        }
      }
    }

    return $links;
  }
  
  function grenola_resultset_array_html_dump($a) {
    if (!@isset($a)) {
      return "<p>a=NULL</p>";
    }
    if (!count($a)) { return "<p>no rows</p>"; }
    $op="<div style=\"font-size:8pt;\"><table border><tr>";
    foreach ($a[0] as $colname=>$whatever) {
      $op.="<td>".sda_htmlentities($colname)."</td>";
    }
    $op.="</tr>";
    foreach ($a as $whatever=>$row) {
      $op.= "<tr>";
      foreach ($row as $whatever2=>$field) {
        $op.= "<td>".sda_htmlentities($field)."</td>";
      }
      $op.= "</tr>";
      if ($i>=count($a)) { break; }
      $row=$a[$i];
      $i++;
    }
    return $op."</table></div>";
  }
  
  function grenola_resultset_html_dump($rset) {
    if (!@isset($rset)) {
      return "<p>resultset=NULL</p>";
    }
    if (FALSE===($row=mysql_fetch_assoc($rset))) {
      return "<p>no rows</p>";
    }
    $op="<table><tr>";
    foreach ($row as $colname=>$whatever) {
      $op.="<td>".sda_htmlentities($colname)."</td>";
    }
    $op.="</tr>";
    while (FALSE!==$row) {
      $op.= "<tr>";
      foreach ($row as $whatever=>$field) {
        $op.= "<td>".sda_htmlentities(field)."</td>";
      }
      $op.= "</tr>";
      $row=mysql_fetch_assoc($rset);
    }
    return $op."</table>";
  }
  
  function person_from_db_row($row) {
    if (!isset($row) || $row===FALSE) { return FALSE; }
    $p=new SDA_Person;
    if (isset($row['person_id']))   { $p->pid=(integer)$row['person_id']; }
    if (isset($row['forenames']))   { $p->forenames=$row['forenames'];    }
    if (isset($row['handle']))      { $p->handle=$row['handle'];          }
    if (isset($row['surname']))     { $p->surname=$row['surname'];        }
    if (isset($row['extra']))       { $p->extra=$row['extra'];            }
    if (isset($row['alternative'])) { $p->alt=$row['alternative'];        }
    return $p;
  }
  
  function mirror_from_db_row($row) {
    if (!isset($row)) { return NULL; }
    if (!is_array($row)) { return NULL; }
    $m=new SDA_Mirror;
    if (isset($row['mirror_id'])) { $m->id=(integer)$row['mirror_id']; }
    if (isset($row['base'])) { $m->base=$row['base']; }
    if (isset($row['use_canonical_dirs'])) {
      $m->use_canonicals=(integer)$row['use_canonical_dirs'];
    }
    if (isset($row['mirror_name'])) { $m->name=$row['mirror_name']; }
    // these two archive-specific
    // (not populated here, separate query to archive_hosed is required):
    $m->primary_hosed=0;
    $m->secondary_hosed=0;
    // data from flavours table
    if (isset($row['flavour_id'])) { $m->flav_id=(integer)$row['flavour_id']; }
    if (isset($row['desc_en_us_short'])) {
      $m->flav_desc_short=$row['desc_en_us_short'];
    }
    if (isset($row['desc_en_us_long'])) {
      $m->flav_desc_long=$row['desc_en_us_long'];
    }
    if (isset($row['suffix'])) { $m->flav_suffix=$row['suffix']; }
    if (isset($row['extension'])) { $m->flav_extension=$row['extension']; }
    if (isset($row['canonical_path_suffix'])) {
      $m->flav_canonical_sfx=$row['canonical_path_suffix'];
    }
    return $m;
  }
  
  function archive_from_db_row($row, $run_name, &$mirror) {
    // pass mirror by reference
    // supplementary SDA_Mirror fields provided by the archive_runs table,
    // for archive-based servers only
    if (!isset($row))    { return 0; }
    if (!is_array($row)) { return 0; }
    if (!isset($mirror)) { return 0; }
    if (!isset($run_name)||$run_name=="") { return 0; }
    $mirror->archive_item=isset($row['item_name'])?$row['item_name']:$run_name;
    $mirror->backup_server_mode=(integer)$row['backup_server_mode'];
    //$s=((integer)$row['us_server']);
    $mirror->archive_server=((integer)$row['us_server']); // numbers only
    $mirror->archive_path=$row['us_server_dir']; // can be NULL
    return 1;
  }
  
  function archive_hosed_from_db_row($row, &$mirror) { // pass mirror by reference
    // populate further SDA_Mirror fields, according to db query
    // on archive_hosed table
    if (!isset($row))    { return 0; }
    if (!is_array($row)) { return 0; }
    if (!isset($mirror)) { return 0; }
    $s=(integer)$mirror->archive_server;
    if (((integer)$row['us_server'])===$s) {
      $mirror->primary_hosed=1;
    } else if (((integer)$row['us_server'])===$s+1) {
      $mirror->secondary_hosed=1;
    }
    return 1;
  }
  
  class SDA_Run {
    var $rid;
    var $num_segs;
    var $time_ms;
    var $time_format;
    var $date;
    var $date_approx;
    var $system_id;
    var $system_name;
    var $notes;
    var $is_il;
    var $catalogue_name_en_us;
    var $name_en_us;
    var $comments;
    var $run_name;
    
    // extended game fields
    var $game_id;
    var $game_sdaname;
    var $game_catalogue_name;
    var $game_name;
    
    // extended IL fields:
    var $level_name_1;
    var $level_name_2;
    var $il_sort_order;
    var $level_id;

    var $cid_tmp;  // used in conversion of single cid to multi cid from db
    var $pid_tmp;  // used in conversion of single pid to multi pid from db

    // category, runner lists:
    var $clist_by_cid;
    var $clist_by_ix;
    var $plist_by_pid;
    var $plist_by_ix;

//    var $cid_list; // multi cid
//    var $c_list;   // multi category objects
//    var $pid_list; // multi pid
//    var $p_list;   // multi person objects

    // this does not contain actual run data, but is just a temp
    // utility variable that is useful for holding data generated during
    // processing (i.e. in game.php)
    //var $aux;
  }
  
  function run_from_db_row($row) {
    if (!isset($row))    { return NULL; }
    if (!is_array($row)) { return NULL; }
    $r=new SDA_Run;
//print_r($row); print "<br><br>";
    if (isset($row['run_id']))         { $r->rid=(integer)$row['run_id']; }
    if (isset($row['segments']))       { $r->num_segs=(integer)$row['segments']; }
    if (isset($row['time_ms']))        { $r->time_ms=(integer)$row['time_ms']; }
    if (isset($row['time_format']))    { $r->time_format=(integer)$row['time_format']; }
    if (isset($row['run_date']))       { $r->run_date=$row['run_date']; }
    if (isset($row['date_is_approx'])) { $r->date_approx=$row['date_is_approx']; }
    if (isset($row['system_id']))      { $r->system_id=(integer)$row['system_id']; }
    if (isset($row['system_name']))    { $r->system_name=$row['system_name']; }
    if (isset($row['notes']))          { $r->notes=$row['notes']; }
    if (isset($row['is_il']))          { $r->is_il=(integer)$row['is_il']; }
    if (isset($row['catalogue_name_en_us'])) {
      $r->catalogue_name_en_us=$row['catalogue_name_en_us'];
    }
    if (isset($row['run_name_override'])) {
      $r->run_name=$row['run_name_override'];
    }
    if (isset($row['sort_order']))     { $r->il_sort_order=$row['sort_order']; }
    if (isset($row['sdaname']))        { $r->game_sdaname=$row['sdaname']; }
    if (isset($row['comments']))       { $r->comments=$row['comments']; }
    if (isset($row['name_en_us']))     { $r->name_en_us=$row['name_en_us']; }
    if (isset($row['game_id']))        { $r->game_id=(integer)$row['game_id']; }
    // backup field for use in queries when game_id is overloaded ...
    // overwrites $r->game_id
    if (isset($row['my_game_id']))     { $r->game_id=(integer)$row['my_game_id']; }
    // note: cid_tmp and pid_tmp used for now, clists and plists will be filled in later
    //       during processing
    if (isset($row['person_id']))      { $r->pid_tmp=(integer)$row['person_id']; }
    if (isset($row['category_id']))    { $r->cid_tmp=(integer)$row['category_id']; }
    if (isset($row['level_name_1']))   { $r->level_name_1=$row['level_name_1']; }
    if (isset($row['level_name_2']))   { $r->level_name_2=$row['level_name_2']; }
    if (isset($row['level_id']))       { $r->level_id=(integer)$row['level_id']; }
    if (isset($row['name_en_us']))     { $r->game_name = $row['name_en_us']; }
    if (isset($row['catalogue_name_en_us'])) {
      $r->game_catalogue_name=$row['catalogue_name_en_us'];
    }
    return $r;
  }
  
  // FIXME: create_sorted_catid_field is made obsolete by the new ['catid_list']=c thing
  function process_runs_from_db_2($rs_runs, // a mysql resultset
                                  &$runs2,
                                  $whatever,
                                  &$level_name_2_count) {
    // this function needs to work for both full-game runs and ILs
    // (ILs have an extended field set)
    $level_name_2_count=0; // determine whether we need to display two level name columns or not
    while (FALSE!==($row=mysql_fetch_assoc($rs_runs))) {
//print_r($row);print "<br><br>";
      // we will get back a row for each category, and a row for each runner,
      // so both categories and runs need logic to group these into a single
      // run with multiple categories and multiple runners.
//print_r($run);print "<br><br>";
      $rid=(integer)$row['run_id'];
      if ($row['is_il']&&isset($row['level_name_2'])&&$row['level_name_2']!=="") {
        $level_name_2_count++;
      }
      if (!isset($runs2[$rid])) {
        // if we haven't seen this run before, add it to the list
        // and set up the arrays used to track and store any multiple fields
        $runobj=run_from_db_row($row);
        $runobj->clist_by_cid=array();
        $runobj->clist_by_ix=array();
        $runobj->plist_by_pid=array();
        $runobj->plist_by_ix=array();
        $runs2[$rid]=$runobj;
      } else {
        $runobj=$runs2[$rid];
      }
      // build up multiple category list
      if (isset($runobj->cid_tmp) && $runobj->cid_tmp) { // ignore DUMMY NULL CATEGORY (category_id=0)
        $c=category_from_db_row($row);
        //$c->mcat_desc_en_us_short=$run['mcat_desc_en_us_short'];

        // categories can be multi
        if (!isset($runobj->clist_by_cid[$c->cid])) { // ignore category IDs we've already seen
          $runobj->clist_by_cid[$c->cid]=$c; // mark category seen
          $runobj->clist_by_ix[]=$c; // preserve order from db
        }
      }
      if (isset($runobj->pid_tmp)&&$runobj->pid_tmp) { // ignore DUMMY NULL RUNNER (person_id=0)
        //$p=new SDA_Person;
        $p=person_from_db_row($row);
        if (!isset($runobj->plist_by_pid[$p->pid])) { // ignore runner IDs we've already seen
          $runobj->plist_by_pid[$p->pid]=$p; // mark runner seen
          $runobj->plist_by_ix[]=$p; // preserve order from db
        }
      }
      $runs2[$rid]=$runobj; // lame
    }
  }
  
/*
| update_id            | int(11)      | NO   | PRI |         |                | 
| game_id              | int(11)      | NO   | PRI | NULL    | auto_increment | 
| redir_game_id        | int(11)      | YES  |     | NULL    |                | 
| catalogue_name_en_us | text         | NO   |     |         |                | 
| name_en_us           | text         | YES  | MUL | NULL    |                | 
| name_sort_order      | int(11)      | NO   | MUL |         |                | 
| release_date         | date         | YES  | MUL | NULL    |                | 
| sdaname              | varchar(255) | NO   |     |         |                | 
| dup_time_ms          | int(11)      | YES  |     | NULL    |                | 
| dup_time_format      | int(11)      | YES  |     | NULL    |                | 
| gl_category_override | int(11)      | YES  |     | NULL    |                | 
| intro_en_us          | text         | NO   |     |         |                | 
| notes_en_us          | text         | YES  |     | NULL    |                | 
| revision_notes       | text         | YES  |     | NULL    |                |
*/

  class SDA_Game {
    var $gid;
    var $catalogue_name;
    var $name;
    var $name_sort_order;
    var $release_date;
    var $release_date_fmt;
    var $sdaname;
    var $min_time_ms;
    var $min_time_format;
    //var $gamelist_cat_override; // unused?
    var $intro;
    var $notes;
    
    // extras from systems table
    var $sysname_multi;
    var $sysid_multi;
  }
  
  function game_from_db_row($row) {
    if (!isset($row)) { sda_die("game_from_db_row(NULL)"); }
    $g=new SDA_Game;
    if (isset($row['game_id'])) { $g->gid=(integer)$row['game_id']; }
    if (isset($row['catalogue_name_en_us'])) { $g->catalogue_name=$row['catalogue_name_en_us']; }
    if (isset($row['name_en_us'])) { $g->name=$row['name_en_us']; }
    if (isset($row['name_sort_order'])) { $g->name_sort_order=(integer)$row['name_sort_order']; }
    if (isset($row['release_date'])) { $g->release_date=$row['release_date']; }
    if (isset($row['release_date_fmt'])) { $g->release_date_fmt=$row['release_date_fmt']; }
    if (isset($row['sdaname'])) { $g->sdaname=$row['sdaname']; }
    if (isset($row['dup_time_ms'])) { $g->min_time_ms=(integer)$row['dup_time_ms']; }
    if (isset($row['dup_time_format'])) { $g->min_time_format=(integer)$row['dup_time_format']; }
    if (isset($row['intro_en_us'])) { $g->intro=$row['intro_en_us']; }
    if (isset($row['notes_en_us'])) { $g->notes=$row['notes_en_us']; }
    if (isset($row['systemname_multi'])) { $g->sysname_multi=$row['systemname_multi']; }
    if (isset($row['systemid_multi'])) { $g->sysid_multi=$row['systemid_multi']; }
    return $g;
  }
  
  function build_game_line_html($g) {
    if (!isset($g)) { sda_die("build_game_line_html(NULL)"); }
    $op="";
    $op.="<a name=\"".$g->gid."\"></a><a href=\"game.php?gid=".$g->gid."\">";
    $op.=sda_htmlentities($g->catalogue_name);
    $op.="</a>";
    if ($g->min_time_ms) {
      $op.=" in ";
      $op.=grenola_format_time($g->min_time_ms, $g->min_time_format);
    }
    $op.=" (";
    $op.=sda_htmlentities($g->sysname_multi);
    $rd=FALSE;
    if (isset($g->release_date) && $g->release_date) { //!=="") { // && $g['release_date']!==0) {
      if (isset($g->release_date_fmt)) {
        $rd=$g->release_date_fmt;
      } else {
        $rd=substr($g->release_date,0,4); // year only
      }
    }
    if (FALSE!==$rd) { $op.=" &mdash; released ".sda_htmlentities($rd); }
    $op.=")";
    return $op;
  }
  
  class SDA_System {
    var $sid;
    var $name;
    var $code_gamelist;
    var $code_archive;
  }
  
  function system_from_db_row($row) {
    if (!isset($row) || !is_array($row)) { sda_die("system_from_db_row(): bad row"); }
    $s=new SDA_System;
    if (isset($row['system_id']))     { $s->sid=(integer)$row['system_id'];      }
    if (isset($row['system_name']))   { $s->name=$row['system_name'];            }
    if (isset($row['code_gamelist'])) { $s->code_gamelist=$row['code_gamelist']; }
    if (isset($row['code_archive']))  { $s->code_archive=$row['code_archive'];   }
    return $s;
  }

?>
